% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPBIB7A.R
\name{GPBIB7A}
\alias{GPBIB7A}
\title{Generalized rectangular right angular (7) design with \eqn{\lambda_{i}}{lambda(i)}
 equal to \eqn{\lambda_{i+4}}{lamda(i+4)} \eqn{(i=1,...,4)}}
\usage{
GPBIB7A(n, l, s, w)
}
\arguments{
\item{n}{Number of lines of the association schemes array.}

\item{l}{Number of columns of the association schemes array.}

\item{s}{Number of the token treatments from the same row of the association scheme.}

\item{w}{Number of the association scheme arrays.}
}
\value{
A LIST :
 \itemize{
  \item \code{PBIB } The configuration of the PBIB.
  \item \code{Type } The type of the design
  \item \code{V } Number of treatments.
  \item \code{B } Number of blocs.
  \item \code{R } Repetition of each treatment.
  \item \code{K } Size of blocs.
  \item \code{lambda } Vector of m-lambda.
  \item \code{Resolvable } Is the design Resolvable ?
  }
}
\description{
gives the configuration and the parametres of the design obtained by
the first construction method of \code{GPBIB_7} (see 3.3.1 of the paper
rezgui et al (2015))
}
\note{
For \eqn{w=2}, the \code{GPBIB_7} is a rectangular right angular (7) (PBIB_7).
}
\examples{
\dontrun{
n<-3
l<-3
s<-3
w<-3
GPBIB7A(n, l, s, w)
}
}
\references{
Imane Rezgui, Z. Gheribi-Aoulmi and H. Monod (2015). U-type Designs via
New Generalized Partially Balanced Incomplete Block Designs with m = 4, 5
and 7 Associated Classes, \doi{10.4236/am.2015.62024}, Applied mathematics, 6, 242-264.

Imane Rezgui, Z.Gheribi-Aoulmi and H. Monod, New association schemes
with 4, 5 and 7 associated classes and their associated partially
balanced incomplete block designs; Advances and Applications in Discrete
Mathematics Vol.12 Issue 2 197-206.
}
\seealso{
\code{\link{GPBIB7B}} and \code{\link{UType}}
}
\author{
Mohamed Laib, Imane Rezgui, Zebida Gheribi-Aoulmi and Herve Monod
}
