% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conTest.R
\name{conTest}
\alias{conTest}
\title{Test significance}
\usage{
conTest(
  data,
  lag = 0,
  conFun,
  typeOfTest = "permut",
  adCor = TRUE,
  nBlox = 10,
  nReps = 100
)
}
\arguments{
\item{data}{Binary time-points-by-variable matrix}

\item{lag}{Non-negative integer indicating how much the second variable is lagged (default 0)}

\item{conFun}{Contingency measure function (calculating the contingency value between two binary vectors). Built in: FunClassJacc, FunCorrJacc, FunKappa, FunOdds, FunLogOdds, FunPropAgree,FunPhiCC}

\item{typeOfTest}{String indicating whether a model-based ('model') or a permutation-based ('permut'; default) data generation approach is used.}

\item{adCor}{Logic indicating the auto-dependence correction should be applied (TRUE; default) or not (FALSE)}

\item{nBlox}{Number indicating the number of segments (default  10).
Necessary for permutation-based test, accounting for auto-dependence
(typeOfTest='permut'; adCor=TRUE)}

\item{nReps}{Number of replicates/samples that is used to generate the test distribution}
}
\value{
A conTest-object including

\code{allLinks} Matrix of pairwise calculated contingency measures

\code{percentile} Matrix of raw percentiles, situating the observed value in the sample distribution

\code{pValue}   Matrix of the p-values (upper one-sided significance test) calculated by subtracting the percentile from 1.

\code{para}: Saving the parameter settings for
\code{typeOfTest}, \code{adCor}, \code{nBlox}, \code{nReps}, \code{funName}, \code{lag}, \code{varNames}

\code{samples} Saved generated replicates/samples for each variable combination under \code{$NameVariable1$NameVariable2}
}
\description{
Test significance
}
\examples{
 signdata=cbind(c(1,0,1,0,1,0,1,0),c(1,1,1,1,0,0,0,0),c(0,0,0,0,0,0,1,1))
           colnames(signdata) <-c ('momangry', 'momsad','adoangry')
           conTest(data=signdata,lag=1,conFun=funClassJacc,typeOfTest='model',
           adCor=FALSE)
}
