% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{clInitializeTernaryQuarts}
\alias{clInitializeTernaryQuarts}
\alias{clInitializeTernarySplits}
\title{Initialize ternary plots for quartet plotting}
\usage{
clInitializeTernaryQuarts(
  zoom = 1,
  padding = 0.1,
  gridLines = 10,
  fontSize = 1,
  gridCol = "#DBDBDB",
  backgroundCol = "#FDFDFE",
  xLim = c(0, 1/zoom) - 0.01,
  yLim = c(0.5 - (1/zoom), 0.5),
  isometric = TRUE
)

clInitializeTernarySplits(
  fontSize = 1,
  xLim = NULL,
  yLim = NULL,
  gridCol = "#DBDBDB",
  backgroundCol = "#FDFDFE",
  padding = 0.1,
  isometric = TRUE
)
}
\arguments{
\item{zoom}{Level of magnification (times), used to adjust ticks and scale.}

\item{padding}{Padding, passed to \code{TernaryPlot}.}

\item{gridLines}{Number of grid lines, passed to \code{TernaryPlot} as \code{grid.lines}.}

\item{fontSize}{Font size, passed to \code{TernaryPlot} as \code{lab.cex}.}

\item{gridCol}{Colour, passed to \code{TernaryPlot} as \code{grid.col}.}

\item{backgroundCol}{Background colour, passed to \code{TernaryPlot} as \code{col}.}

\item{xLim, yLim}{x and y limits, passed to \code{TernaryPlot} as \code{xlim}, \code{ylim}.}

\item{isometric}{Logical specifying whether plot should be isometric, passed
to \code{TernaryPlot} as \code{isometric}.}
}
\description{
Sets up a blank ternary plot ready for analytical results to be added.
}
\section{Functions}{
\itemize{
\item \code{clInitializeTernarySplits()}: Initialize ternary plots for
partition plotting.

}}
