% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExclusiveConnectedness.R
\name{ExclusiveConnectedness}
\alias{ExclusiveConnectedness}
\title{Exclusive Connectedness Measures}
\usage{
ExclusiveConnectedness(dca, group = c(1, 2), start = NULL, end = NULL)
}
\arguments{
\item{dca}{Dynamic connectedness object}

\item{group}{Vector of group indices}

\item{start}{Start index}

\item{end}{End index}
}
\value{
Get connectedness measures
}
\description{
This function results in exclusive connectedness measures
}
\examples{
\donttest{
#Replication of Chatziantoniou, et al. (2022)
data("cegg2022")
dca = ConnectednessApproach(cegg2022,
                            nlag=1,
                            nfore=20,
                            model="VAR",
                            connectedness="Time",
                            corrected=TRUE)
exc = ExclusiveConnectedness(dca, group=c(1,2,3))
}
}
\references{
Chatziantoniou, I., Elsayed, A. H., Gabauer, D., & Gozgor, G. (2023). Oil price shocks and exchange rate dynamics: Evidence from decomposed and partial connectedness measures for oil importing and exporting economies. Energy Economics, 120, 106627.
}
\author{
David Gabauer
}
