% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll_ConsRegArima.R
\name{rolling}
\alias{rolling}
\title{rolling: Back-test your model}
\usage{
rolling(object, used.sample, refit, h = 1, orig.data, ...)
}
\arguments{
\item{object}{ConsRegArima object}

\item{used.sample}{The starting point in the dataset from which
to initialize the rolling forecast.}

\item{refit}{Determines every how many periods the model is re-estimated.
If \code{refit}=0, then no refit is doing}

\item{h}{The number of periods to forecast}

\item{orig.data}{data original which was used to estimate the ConsRegArima \code{object}}

\item{...}{Additional params for predict function}
}
\value{
\item{results}{data.frame with Real, Prediction, Prediction_High,
 Prediction_Low and fitted values of the \code{object}}
 \item{refitT}{how many periods the model is re-estimated}
 \item{metrics}{Main metrics of the predictions}
}
\description{
Function for creating rolling density forecast from \code{ConsRegArima} models with
option for refitting every n periods.
}
\examples{
data('series')
fit1 = ConsRegArima(formula = y ~ x1+x2 +x3, order = c(2, 1),
                    optimizer = 'solnp', data = series)
roll = rolling(fit1, used.sample = 40,
               refit = 5, orig.data = series, h=3)
roll
plot(roll)

}
\seealso{
\code{\link[ConsReg]{plot.roll.ConsRegArima}}
}
