% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreConcept.R
\name{coreVertices}
\alias{coreVertices}
\title{Compute core vertices}
\usage{
coreVertices(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
rows of the matrix are the vertices of the core
}
\description{
Calculates the core vertices for given game vector
}
\examples{
library(CoopGame)
coreVertices(c(0,0,0,1,1,1,3))

\donttest{
#In the following case the core consists of a single point
v1 = c(0,1,2,3,4,5,6)
coreVertices(v1)
#     [,1] [,2] [,3]
#[1,]    1    2    3

#Users may also want to try the following commands:
coreVertices(c(0,0,0,60,80,100,135))
coreVertices(c(5,2,4,7,15,15,15,15,15,15,20,20,20,20,35))
coreVertices(c(0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,15,15,15,15,15,15,15,15,15,15,30,30,30,30,30,60))
}

}
\references{
Gillies D.B. (1953)  \emph{Some Theorems on n-person Games}, Ph.D. Thesis, Princeton University Press.

Aumann R.J. (1961) "The core of a cooperative game without side payments", Transactions of the American Mathematical Society 98(3), pp. 539--552

Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, pp. 27--49

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, pp. 686--747

Osborne M.J. and Rubinstein A. (1994) \emph{A Course in Game Theory}, MIT Press, pp. 257--275
}
\author{
Franz Mueller

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
