% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCriticalCoalitionsOfPlayer.R
\name{getCriticalCoalitionsOfPlayer}
\alias{getCriticalCoalitionsOfPlayer}
\title{Compute critical coalitions of a player for simple games}
\usage{
getCriticalCoalitionsOfPlayer(player, v)
}
\arguments{
\item{player}{represents the observed player}

\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
A data frame containing all minimal winning coalitions for one special player
}
\description{
getCriticalCoalitionsOfPlayer identifies all coalitions for one player
in which that player is critical (within a simple game).
These coalitions are characterized by the circumstance that without this player the other players
generate no value (then also called a losing coalition) - therefore this player is also described as a critical player.
}
\examples{
library(CoopGame)
getCriticalCoalitionsOfPlayer(2,v=c(0,0,0,0,0,1,1))

\donttest{
library(CoopGame)
v=c(0,1,0,1,0,1,1)

#Get coalitions where player 2 is critical:
getCriticalCoalitionsOfPlayer(2,v)
#Output are all coalitions where player 2 is involved.
#Observe that player 2 is dictator in this game.
#
#     V1 V2 V3 cVal bmRow
#  2  0  1  0    1     2
#  4  1  1  0    1     4
#  6  0  1  1    1     6
#  7  1  1  1    1     7
}

}
\references{
Deegan J. and  Packel E.W. (1978) "A new index of power for simple n-person games", Int. Journal of Game Theory 7(2), pp. 151--161
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
