% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilag.cpts.merge.R
\name{multilag.cpts.merge}
\alias{multilag.cpts.merge}
\title{Merge Change Point Estimators from Multiple Lags}
\usage{
multilag.cpts.merge(
  x.c,
  eta.merge = 1,
  merge.type = c("sequential", "bottom-up")[1]
)
}
\arguments{
\item{x.c}{A \code{list} object, where each element of the list is the output of the \link{np.mojo} function computed at a
different lag.}

\item{eta.merge}{A positive numeric value for the minimal mutual distance of
changes, relative to bandwidth, used to merge change point estimators across different lags.}

\item{merge.type}{String indicating the method used to merge change point estimators from different lags. Possible choices are
 \itemize{
   \item \code{"sequential"}: starting from the left-most change point estimator and proceeding forward in time, estimators
   are grouped into clusters based on mutual distance. The estimator yielding the largest corresponding importance score is
   chosen as the change point estimator for that cluster. See McGonigle and Cho (2025) for details.
       \item \code{"bottom-up"}: starting with the largest importance score, the change points are merged using bottom-up merging (Messer
       et al. (2014)).
}}
}
\value{
A \code{list} object which contains the following fields
\item{cpts}{A matrix with rows corresponding to final change point estimators, with estimated change point location and associated lag and importance score given in columns.}
   \item{cpt.clusters}{A \code{list} object of length given by the number of detected change points. Each field contains a matrix of all
   change point estimators that are declared to be associated to the corresponding change point in the \code{cpts} field.}
}
\description{
Merges change point estimators from different lagged values into a final set of overall change point estimators.
}
\details{
See McGonigle and Cho (2025) for further details.
}
\examples{
set.seed(1)
n <- 500
noise <- c(rep(1, 300), rep(0.4, 200)) * stats::arima.sim(model = list(ar = 0.3), n = n)
signal <- c(rep(0, 100), rep(2, 400))
x <- signal + noise
x.c0 <- np.mojo(x, G = 83, lag = 0)
x.c1 <- np.mojo(x, G = 83, lag = 1)
x.c <- multilag.cpts.merge(list(x.c0, x.c1))
x.c
}
\references{
McGonigle, E.T., Cho, H. (2025). Nonparametric data segmentation in multivariate time series via joint characteristic functions.
\emph{Biometrika} (to appear).

Messer M., Kirchner M., Schiemann J., Roeper J., Neininger R., Schneider G. (2014). A Multiple Filter Test for
the Detection of Rate Changes in Renewal Processes with Varying Variance. \emph{The Annals of Applied Statistics}, 8(4), 2027-2067.
}
\seealso{
\link{np.mojo}, \link{np.mojo.multilag}
}
