% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liftIndex.R
\name{liftIndex}
\alias{liftIndex}
\title{Calculate lift index}
\usage{
liftIndex(predTest, depTest)
}
\arguments{
\item{predTest}{Vector with predictions (real-valued or discrete)}

\item{depTest}{Vector with true class labels}
}
\value{
Lift index value
}
\description{
Calculates lift index metric.
}
\examples{
## Load response modeling predictions
data("response")
## Calculate lift index for test sample results
li<-liftIndex(response$test[,2],response$test[,1])
print(li)

}
\references{
Berry, M.J.A. and Linoff, G.S. (2004): "Data Mining Techniques: For Marketing, Sales, and
Customer Relationship Management - Second Edition". John Wiley & Sons.
}
\seealso{
\code{\link{liftTable}}, \code{\link{topDecileLift}}, \code{\link{liftChart}}
}
\author{
Koen W. De Bock, \email{kdebock@audencia.com}
}
