% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternary.R
\name{plotTernary}
\alias{plotTernary}
\alias{plotTernary.default}
\title{Create ternary simplex plots}
\usage{
plotTernary(x, ...)

\method{plotTernary}{default}(
  x,
  clusterVar,
  vertices,
  features = NULL,
  veloGraph = NULL,
  byCluster = NULL,
  processed = FALSE,
  method = c("euclidean", "cosine", "pearson", "spearman"),
  force = FALSE,
  sigma = 0.08,
  scale = TRUE,
  dotColorBy = NULL,
  dotColor = NULL,
  palette = "D",
  direction = 1,
  breaks = NULL,
  legendTitle = NULL,
  returnData = FALSE,
  ...
)
}
\arguments{
\item{x}{Input data. Can be a \code{matrix} or \code{dgCMatrix} object with
cells as columns, a \code{Seurat} or \code{SingleCellExperiment} object.
"simMat" method takes intermediate values.}

\item{...}{
  Arguments passed on to \code{\link[=plotTernary.simMat]{plotTernary.simMat}}
  \describe{
    \item{\code{title}}{Title text of the plot. Default \code{NULL}.}
    \item{\code{nGrid}}{Number of grids along the bottom side of the equilateral
triangle. Default \code{10}.}
    \item{\code{radius}}{Arrow length of unit velocity. Lower this when arrows point
outside of the coordinate. Default \code{0.1}.}
    \item{\code{dotSize}}{Dot aesthetics passed to \code{geom_point}. Default \code{0.6}
when not interactive, \code{4} when interactive.}
    \item{\code{dotShuffle}}{Whether to shuffle the order of dots being added to the
plot, useful when categorical colors are used and mixing of categories is
expected. Default \code{NULL} does shuffle when \code{dotColorBy} given is
categorical and does not otherwise.}
    \item{\code{labelColors}}{Colors of the axis lines and vertex labels.
Default \code{c("#3B4992FF", "#EE0000FF", "#008B45FF")} (blue, red and green)}
    \item{\code{vertexLabelSize}}{Size of vertex labels. Default \code{6} when not
interactive, \code{16} when interactive.}
    \item{\code{vertexLabelDrift}}{Position adjustment of the vertex labels, only
applied to non-interactive view. Default \code{0.03}.}
    \item{\code{axisBreak}}{Number of breaks to be labeled along axis. Default
\code{5}.}
    \item{\code{axisTextShow}}{Logical, whether to show axis text. Default \code{TRUE}.}
    \item{\code{axisTextSize}}{Size of text along each axis break. Default \code{4} for
non-interactive view, \code{12} for interactive view.}
    \item{\code{axisTextDrift}}{Position adjustment of the axis text, only applied to
non-interactive view. Default \code{0.01}.}
    \item{\code{gridLineAlpha}}{Transparency of background grid lines. Default
\code{0.6}.}
    \item{\code{arrowLinewidth}}{Line width of the velocity arrows. Default \code{0.25}
for non-interactive view, \code{2} for interactive view.}
    \item{\code{arrowAngle}}{Controls the angle of the arrowhead, only applied to
non-interactive view. Default \code{20}.}
    \item{\code{arrowLen}}{Control length in centimetre from arrow tip to arrow tail,
only applied to non-interactive view. Default \code{0.2}.}
    \item{\code{titleSize}}{Size of title text. Default \code{14} for non-interactive
view, \code{20} for interactive view.}
    \item{\code{equilateral}}{Logical, whether to always display the triangle as
equilateral. Default \code{TRUE}.}
    \item{\code{margin}}{Margin allowed around of the triangle plotting region when
\code{equilateral = TRUE}}
    \item{\code{interactive}}{Logical. Whether to display plotly interactive view.
Default \code{FALSE}.}
  }}

\item{clusterVar}{A vector/factor assigning the cluster variable to each
column of the matrix object. For "Seurat" method, \code{NULL} (default) for
\code{Idents(x)}, or a variable name in \code{meta.data} slot. For
"SingleCellExperiment" method, \code{NULL} (default) for \code{colLabels(x)},
or a variable name in \code{colData} slot.}

\item{vertices}{Vector of three unique cluster names that will be used for
plotting. Or a named list that groups clusters as three terminal vertices.
There must not be any overlap between groups.}

\item{features}{Valid matrix row subsetting index to select features for
similarity calculation. Default \code{NULL} uses all available features.}

\item{veloGraph}{Cell x cell \code{dgCMatrix} object containing velocity
information. Shows velocity grid-arrow layer when specified. Default
\code{NULL} does not show velocity.}

\item{byCluster}{Default \code{NULL} to generate one plot with all cells.
Set \code{"all"} to split cells in plot by cluster and returns a list of
subplots for each cluster as well as the plot including all cells. Otherwise,
a vector of cluster names to generate a list of subplots for the specified
clusters.}

\item{processed}{Logical. Whether the input matrix is already processed.
\code{TRUE} will bypass internal preprocessing and input matrix will be
directly used for similarity calculation. Default \code{FALSE} and raw count
input is recommended. If missing in call, using \code{slot = "counts"} in
"Seurat" method or using \code{assay.type = "counts"} in
"SingleCellExperiment" method will force this argument to be \code{FALSE} and
others for \code{TRUE}.}

\item{method}{Similarity calculation method. Default \code{"euclidean"}.
Choose from \code{"euclidean"}, \code{"cosine"}, \code{"pearson"},
\code{"spearman"}.}

\item{force}{Whether to force calculate the similarity when more then 500
features are detected, which is generally not recommended. Default
\code{FALSE}.}

\item{sigma}{Gaussian kernel parameter that controls the effect of variance.
Only effective when using a distance metric (i.e. \code{method} is
\code{"euclidian"} or \code{"cosine"}). Larger values tighten the dot
spreading on figure. Default \code{0.08}.}

\item{scale}{Whether to min-max scale the distance matrix by clusters.
Default \code{TRUE}.}

\item{dotColorBy}{A vector/factor for coloring dots, can be either categorical
(must be character or factor) or continuous. Default \code{NULL}.}

\item{dotColor}{Character vector of color codes. When \code{dotColorBy} is
\code{NULL}, use one or as many colors as the number of cells. If
\code{dotColorBy} is categorical, specify as many colors
as the number of categories in \code{dotColorBy} or ggplot2 categorical
color palette is used by default. If \code{dotColorBy} is continuous, specify
together with \code{breaks} argument.}

\item{palette}{Color palette to use when \code{dotColorBy} is given. Default
\code{"D"} (viridis) for continuous value and ggplot2 default for categorical
value. See detail for alternatives.}

\item{direction}{Sets the order of colors in the scale. Default \code{1}
orders as palette default. If \code{-1}, the order of colors is reversed.}

\item{breaks}{Number of breaks for continuous color scale passed to
non-interactive "plot3D::scatter3D" call. Default \code{NULL}.}

\item{legendTitle}{Title on the legend/colorbar. Default \code{NULL} uses
\code{"cluster"} if \code{dotColorBy} is missing (default); user-end variable
expression if \code{dotColorBy} is directly specified from
plotQuaternary.default method; variable name if \code{dotColorBy} is
specified from Seurat or SingleCellExperiment method.}

\item{returnData}{Logical. Whether to return similarity and aggregated
velocity data if applicable instead of generating plot. Default \code{FALSE}.}
}
\value{
By default, a "ggplot" object when \code{byCluster} is not specified,
a list of "ggplot" object when \code{byCluster} is specified. When
\code{interactive = TRUE}, a "plotly" object is returned. When
\code{returnData = TRUE}, a list of similarity matrix and aggregated velocity
matrix is returned.
}
\description{
Create ternary plots that show similarity between single cells and
selected three terminals in a ternary baricentric coordinate.
}
\details{
\bold{Argument inheritance} - For matrix/dgCMatrix ("default" method), we
first calculate the similarity matrix and obtain a "simMat" object. Then the
"simMat" method is internally called. For data container objects (e.g.
Seurat), we obtain the correct data matrix first and then call the "default"
method. The arguments inherits as the flow described above.

\bold{The calculation of similarity matrix} - The similarity is calculated
either by converting a distance metric ("euclidean" or "cosine") with
Gaussian kernel, or directly computed with correlation metrics ("pearson" or
"spearman"). The centroid of each terminal is obtained first, and the
specified metric from each cell to each terminal is calculated. The
similarity matrix (n cells by v terminals) is lastly normalized to sum to 1
for each cell, so it becomes a baricentric coordinate.
}
\examples{
gene <- selectTopFeatures(rnaRaw, rnaCluster, c("OS", "RE", "CH"))
plotTernary(rnaRaw, rnaCluster, c("OS", "RE", "CH"), gene)
}
\seealso{
Other plotTernary: 
\code{\link{plotTernary.Seurat}()},
\code{\link{plotTernary.SingleCellExperiment}()}
}
\concept{plotTernary}
