% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggb.R
\name{ggbcoverageFromYear}
\alias{ggbcoverageFromYear}
\title{estimate death registration coverage for a single year/sex/region using the GGB method}
\usage{
ggbcoverageFromYear(codi, exact.ages = NULL, minA = 15, maxA = 75,
  minAges = 8, deaths.summed = FALSE)
}
\arguments{
\item{codi}{\code{data.frame} with columns, \code{$pop1}, \code{$pop2}, \code{$deaths}, \code{$date1}, \code{$date2}, and \code{$age}.}

\item{exact.ages}{optional. use an exact set of ages to estimate coverage.}

\item{minA}{the minimum of the age range searched. Default 15}

\item{maxA}{the maximum of the age range searched. Default 75}

\item{minAges}{the minimum number of adjacent ages needed as points for fitting. Default 8}

\item{deaths.summed}{logical. is the deaths column given as the total per age in the intercensal period (\code{TRUE}). By default we assume \code{FALSE}, i.e. that the average annual was given.}
}
\value{
a \code{data.frame} with columns for the coverage coefficient, and the min and max of the age range on which it is based.
}
\description{
Given two censuses and an average annual number of deaths in each age class between censuses, we can use stable population assumptions to estimate the degree of underregistration of deaths. The method is based on finding a best-fitting linear relationship between two modeled parameters (right term and left term), but the fit, and resulting coverage estimate, depend on exactly which age range is taken. This function either finds a nice age range for you automatically, or you can specify an exact vector of ages. Called by \code{ggb()}. Users probably don't need to call this directly. Just use \code{ggb()} instead.

Census dates can be given in a variety of ways: 1) using Date classes, and column names \code{$date1} and \code{$date2} (or an unambiguous character string of the date, like, \code{"1981-05-13"}) or 2) by giving column names \code{"day1","month1","year1","day2","month2","year2"} containing integers. If only \code{year1} and \code{year2} are given, then we assume January 1 dates. If year and month are given, then we assume dates on the first of the month.
}
