% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_methods.R
\name{calib_02}
\alias{calib_02}
\title{Calculate calibration metrics of previously filtered tracks (fine-scale or large-scale)}
\usage{
calib_02(track_cleaned, option)
}
\arguments{
\item{track_cleaned}{A dataframe of the filtered track (either fine scale of large scale).}

\item{option}{A character string, either `"fine"` or `"large"`, indicating which type of movement (fine-scale or large-scale)
metrics to return.`"fine"` returns home range, mean net squared displacement, and mean residence time. `"large"` returns home range,
maximum net squared displacement, sinuosity and cumulative distance moved.}
}
\value{
A dataframe storing either fine scale metrics (home range (HR, km2), mean net squared displacement (NSD, km2)
and mean residence time (RT, days)) or large scale metrics (HR, max NSD, sinuosity index and cumulative distance moved (km)).
}
\description{
Calculate calibration metrics of previously filtered tracks (fine-scale or large-scale)
}
\examples{
\dontrun{
# filtering fine-scale movements on porpoise tracks

data(porpoisetrack)
track <-as.data.frame(porpoisetrack)
track$year <- track$tick / 17280
track$yearRound <- floor(track$year) + 1
track$tickNew <- ave(track$tick, track$Id, track$yearRound, FUN = seq_along)
track$day <- track$tickNew / 48
track$dayRound <- floor(track$day) + 1
track$date <- as.POSIXct("2014-01-01 00:00:00", tz = "GMT") + (track$tick * 1800)
track_fine <- track[track$DispersalMode == 0, ]

noon_tracks <- track_fine[format(track_fine$date, "\%H:\%M:\%S") == "12:00:00", ]

# identify 30 consecutive days with noon data
all_days <- sort(unique(as.Date(noon_tracks$date)))
consecutive_days <- NULL

for (i in 1:(length(all_days) - 29)) {
if (all(diff(all_days[i:(i + 29)]) == 1)) {
 consecutive_days <- all_days[i:(i + 29)]
 break
}
}
# filter data to only the 30 consecutive days
filtered_tracks <- noon_tracks[as.Date(noon_tracks$date) \%in\% consecutive_days, ]

calib_02(filtered_tracks, option = "fine")
}
}
