% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_tools.R
\name{plotWSAFvsPLAF}
\alias{plotWSAFvsPLAF}
\title{Plot WSAF vs PLAF}
\usage{
plotWSAFvsPLAF(
  plaf,
  obsWSAF,
  expWSAF = c(),
  potentialOutliers = c(),
  title = "WSAF vs PLAF",
  cex.lab = 1,
  cex.main = 1,
  cex.axis = 1
)
}
\arguments{
\item{plaf}{Numeric array of population level allele frequency.}

\item{obsWSAF}{Numeric array of observed altenative allele frequencies within sample.}

\item{expWSAF}{Numeric array of expected WSAF from model.}

\item{potentialOutliers}{Potential outliers}

\item{title}{Figure title, "WSAF vs PLAF" by default}

\item{cex.lab}{Label size.}

\item{cex.main}{Title size.}

\item{cex.axis}{Axis text size.}
}
\value{
No return value called for side effects
}
\description{
Plot allele frequencies within sample against population level.
}
\examples{
# Example 1
refFile <- system.file("extdata", "PG0390-C.test.ref", package = "DEploid.utils")
altFile <- system.file("extdata", "PG0390-C.test.alt", package = "DEploid.utils")
PG0390CoverageTxt <- extractCoverageFromTxt(refFile, altFile)
obsWSAF <- computeObsWSAF(PG0390CoverageTxt$altCount, PG0390CoverageTxt$refCount)
plafFile <- system.file("extdata", "labStrains.test.PLAF.txt", package = "DEploid.utils")
plaf <- extractPLAF(plafFile)
plotWSAFvsPLAF(plaf, obsWSAF)

# Example 2
vcfFile <- system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid.utils")
PG0390CoverageVcf <- extractCoverageFromVcf(vcfFile, "PG0390-C")
obsWSAF <- computeObsWSAF(PG0390CoverageVcf$altCount, PG0390CoverageVcf$refCount)
plafFile <- system.file("extdata", "labStrains.test.PLAF.txt", package = "DEploid.utils")
plaf <- extractPLAF(plafFile)
plotWSAFvsPLAF(plaf, obsWSAF)

}
