% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfba_beta_descriptive.R
\name{dfba_beta_descriptive}
\alias{dfba_beta_descriptive}
\title{Descriptive Statistics for a Beta Distribution}
\usage{
dfba_beta_descriptive(a, b, prob_interval = 0.95)
}
\arguments{
\item{a}{The first shape parameter for the beta distribution. Must be positive and finite.}

\item{b}{The second shape parameter for the beta distribution. Must be positive and finite.}

\item{prob_interval}{Desired probability within interval limits (default is .95)}
}
\value{
A list containing the following components:

\item{a}{The first beta shape parameter}

\item{b}{The second beta shape parameter}

\item{prob_interval}{The probability for interval estimates}

\item{x_mean}{The mean of the distribution}

\item{x_median}{The median of the distribution}

\item{x_mode}{The mode for the distribution}

\item{x_variance}{The variance for the distribution}

\item{eti_lower}{The equal-tail lower interval limit}

\item{eti_upper}{The equal-tail upper interval limit}

\item{hdi_lower}{The lower limit for the highest-density interval}

\item{hdi_upper}{The upper limit for the highest-density interval}

\item{outputdf}{A dataframe of \code{x}, density, and cumulative probability for \code{x} from 0 to 1 in steps of .005}
}
\description{
Given the two shape parameters for a beta distribution, the function provides
central tendency statistics, interval limits, and density and cumulative
probabilities.
}
\details{
The density function for a beta variate is
\deqn{f(x) = \begin{cases} Kx^{a-1}(1-x)^{b-1} & \quad \textrm{if } 0 \le x \le 1, \\0 & \quad \textrm{otherwise} \end{cases}}
where \deqn{K = \frac{\Gamma(a + b)}{\Gamma(a)\Gamma(b)}.}
(Johnson, Kotz, & Balakrishnan, 1995). The two shape parameters \eqn{a} and \eqn{b} must
be positive values.

The \code{dfba_beta_descriptive()} function provides features
to complement the beta distribution functions available in the \strong{stats}
package. The function provides the mean, median, mode, and variance for a
beta variate in terms of its two shape parameters.

While the mean, variance, and median are straightforward, there are several
conditions that result in an undefined mode. When either (1) \eqn{a = b = 1},
(2)  \eqn{a < 1}, or (3) \eqn{b < 1}, the mode is undefined. For example,
when \eqn{a = b = 1}, the function is the uniform distribution, which does not
have a modal value. The other cases above result in the density function
diverging at either \eqn{x = 0} or \eqn{x = 1}. The function returns a value of
\code{NA} for the mode for all the cases where a unique mode does not exist.

For interval estimation, the function finds an equal-tail interval limits in
all cases, and it also provides the highest-density limits when there is a
well-defined mode. When the mode does not exist, the function returns \code{NA}
for the limits for the highest-density interval (HDI). For interval
estimation, the probability between the lower and upper limit is the
probability specified in the \code{prob_interval} input. The
\code{dfba_beta_descriptive()} output object includes a dataframe that has
density and cumulative probability information that can be used for plotting.
}
\examples{

dfba_beta_descriptive(a = 38,
                      b = 55)

dfba_beta_descriptive(38,
                      55,
                      prob_interval=.99)

}
\references{
Johnson, N. L., Kotz S., and Balakrishnan, N. (1995). \emph{Continuous Univariate}
\emph{Distributions}, Vol. 1, New York: Wiley.
}
\seealso{
\code{\link[stats:Distributions]{Distributions}} for additional details on
functions for the beta distribution in the \strong{stats} package.
}
