% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IRTSE.R
\name{Ase1pl}
\alias{Ase1pl}
\title{Calculates the asymptotic variance for difficulty parameter estimates under the 1pl model}
\usage{
Ase1pl(
  itemParameters,
  distribution = "norm",
  distributionParameters = list(mean = 0, sd = 1),
  logistic = TRUE,
  sampleSize = 1,
  subdivisions = 5000
)
}
\arguments{
\item{itemParameters}{A matrix or vector containing the item difficulties.}

\item{distribution}{A string character indicating the generic name for the assumed distribution.}

\item{distributionParameters}{A list of extra parameters for the distribution function.}

\item{logistic}{A logical indicating whether the logistic or the normal metric should be used.}

\item{sampleSize}{A value indicating the sample size.}

\item{subdivisions}{A numeric value stating the maximum number of subdivisions for adaptive quadrature.}
}
\value{
ase A list containing the asymptotic variances for each item
}
\description{
Calculates the asymptotic variance for difficulty parameter estimates under the 1pl model
}
\references{
Li, Y. & Lissitz, R. (2004). Applications of the analytically derived standard errors of Item Response Theory item parameter estimates. Journal of educational measurement, 41(2), 85--117. doi:10.1111/j.1745-3984.2004.tb01109.x
}
\author{
Victor H. Cervantes <vhcervantesb at unal.edu.co>
}
