% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_timestamp.R
\name{pretty_timestamp}
\alias{pretty_timestamp}
\title{Quickly get a pretty timestamp without
  need to handle format-options etc.}
\usage{
pretty_timestamp(timestamp, no_spaces = FALSE)
}
\arguments{
\item{timestamp}{A POSIXct timestamp or a string which ca be converted to
a POSIXct timestamp.}

\item{no_spaces}{Boolean. Default = `FALSE`. Specifies whether the output
can contain spaces or not. E.g. if the output is for human reading,
`no_spaces = FALSE` is a good option. As suffix for file names
(e.g. logfiles), `no_spaces = TRUE` might be a good option.}
}
\value{
The timestamp in always the same format.
#'
}
\description{
Function to quickly get a pretty timestamp without
  need to handle format-options etc.
}
\examples{
pretty_timestamp("2023-10-30 12:34:56", no_spaces = TRUE)
# Result: "2023-10-30T123456"
pretty_timestamp("2023-10-30 12:34:56")
# this is the same like
pretty_timestamp("2023-10-30 12:34:56", no_spaces = FALSE)
# Result: "30. Oct 2023 - 12:34 UTC"

}
