% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.cv.DMR.R
\name{coef.cv.DMR}
\alias{coef.cv.DMR}
\title{coef.cv.DMR}
\usage{
\method{coef}{cv.DMR}(object, md = "df.min", ...)
}
\arguments{
\item{object}{Fitted \code{cv.DMR} object.}

\item{md}{Value of the model dimension parameter at which predictions are required. The default is \code{md="df.min"} value indicating the model minimizing the cross validation error. Alternatively, \code{md="df.1se"} can be used, indicating the smallest model falling under the upper curve of a minimal prediction error plus one standard error.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Vector of coefficients.
}
\description{
Extracts coefficients from a \code{cv.DMR} object (for the model with minimal cross-validated error /the default/ or the smallest model falling under the upper curve of a minimal prediction error plus one standard error).
}
\details{
Similar to other \code{coef} methods, this function extracts coefficients from a fitted \code{cv.DMR} object.
}
\examples{
## cv.DMR for linear regression
set.seed(13)
data(miete)
y <- miete$rent
X <- miete$area
cv = cv.DMR(X,y)
coef(cv)

}
