% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{mixpar}
\alias{mixpar}
\alias{print.mixpar}
\title{Parameters for DNA mixture models}
\usage{
mixpar(rho = NULL, eta = NULL, xi = NULL, phi = NULL, parlist = NULL)

\method{print}{mixpar}(x, digits = max(3L, getOption("digits") - 3L), scientific = FALSE, ...)
}
\arguments{
\item{rho}{Amplification factor.}

\item{eta}{Scale parameter in the gamma distribution.}

\item{xi}{Stutter parameter.}

\item{phi}{Named vector of the fraction of DNA contributed by each contributor.}

\item{parlist}{A list of parameters of class \code{mixpar}}

\item{x}{An object of class \code{mixpar}.}

\item{digits}{The number of digits to print}

\item{scientific}{Should scientific notation be used?}

\item{...}{arguments passed to print}
}
\value{
An object of class "mixpar".
}
\description{
\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which
is intended as a service to enable users to try \pkg{DNAmixtures}
without purchasing a commercial licence for Hugin. When at all
possible, we strongly recommend the use of \pkg{DNAmixtures}
rather than this lite-version. See
\url{https://dnamixtures.r-forge.r-project.org/} for details on
both packages.}

\emph{While the lite-version seeks to provide the full functionality of
\pkg{DNAmixtures}, note that computations are much less efficient
and that there are some differences in available functionality. Be
aware that the present documentation is copied from
\pkg{DNAmixtures} and thus may not accurately describe the
implementation of this lite-version.}
}
\details{
The mixture parameter is a two-way array of lists;
columns correspond to the four model parameters \code{rho},
\code{eta}, \code{xi}, and \code{phi}, and rows correspond to the
mixtures included in the model.

The print method is currently somewhat specialised, in that it
assumes that \code{rho}, \code{eta}, and \code{xi} are merely real
numbers. \code{phi} is assumed to consist of a named vector per
mixture; the names, or order of names, can differ between mixtures.
}
\examples{
## A parameter for two mixtures
q <- mixpar(rho = list(30, 30), eta = list(30, 30), xi = list(0.08, 0.08),
            phi = list(c(Anna = 0.5, Peter = 0.2, U1 = 0.3),
                       c(U1 = 0.5, Anna = 0.2, Peter = 0.3)))
## Equivalent to specifying the parameter for each mixture and then combining.
p1 <- mixpar(rho = list(30), eta = list(30), xi = list(0.08),
             phi = list(c(Anna = 0.5, Peter = 0.2, U1 = 0.3)))
p2 <- mixpar(rho = list(30), eta = list(30), xi = list(0.08),
             phi = list(c(U1 = 0.5, Anna = 0.2, Peter = 0.3)))
p <- mixpar(parlist = list(p1, p2))
}
\author{
Therese Graversen
}
