% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.DNAmixture}
\alias{predict.DNAmixture}
\title{Various probabilities in a fitted DNA mixture model}
\usage{
\method{predict}{DNAmixture}(
  object,
  pars,
  dist = c("joint", "conditional", "prequential"),
  markers = object$markers,
  by.allele = TRUE,
  initialize = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{\link{DNAmixture}} object}

\item{pars}{Array of model parameters}

\item{dist}{One of "joint", "conditional", and "prequential". If
there are only known contributors, these are all the same since, under the model, peak
heights are condtionally independent given profiles of the
contributors.}

\item{markers}{The set of markers of interest}

\item{by.allele}{If \code{dist = "prequential"} then the order in
which we condition on mixtures and alleles matters. \code{by.allele
= TRUE} will proceed through alleles in increasing repeat number,
and for each allele condition on one mixture at the time. If \code{FALSE},
the conditioning is done by mixtures and then alleles within these.}

\item{initialize}{By default \code{predict} removes all entered
evidence from the networks in \code{object}. Setting
\code{initialize = FALSE} should be done with care, and it is up
to the user to ensure that the returned probabilities are meaningful.}

\item{...}{Not used}
}
\value{
A list with one data.frame per marker containing various probabilities for
diagnostics
\item{unseen}{The probability of not seeing a peak, i.e. no peak or a peak falling below the threshold}
\item{seen}{The probability of seeing the allele}
\item{smaller}{The probability of seeing a smaller peak than the
one observed}
\item{larger}{The probability of seeing a larger
peak than the one observed}
}
\description{
\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which is intended as a service to enable users to try \pkg{DNAmixtures} without purchasing a commercial licence for Hugin. When at all possible, we strongly recommend the use of \pkg{DNAmixtures} rather than this lite-version. See \url{https://dnamixtures.r-forge.r-project.org/} for details on both packages.}

\emph{While the lite-version seeks to provide the full functionality of \pkg{DNAmixtures}, note that computations are much less efficient and that there are some differences in available functionality. Be aware that the present documentation is copied from \pkg{DNAmixtures} and thus may not accurately describe the implementation of this lite-version.}
}
\details{
For a mixture with unknown contributors, the
probabilities are computed with respect to one of three
distributions. Let \code{height} be the matrix of peak heights
with columns \code{height1, \ldots, heightR}. For a peak at allele \code{a} in the mixture \code{r}, the three choices of distributions are
\describe{
\item{\code{"joint"}}{Default. No conditioning on observed peak heights.}
\item{\code{"conditional"}}{Conditional on \code{height[-a, -r]}, i.e. on heights for all peaks, except the one under consideration.}
\item{\code{"prequential"}}{Conditional on \code{height[1:(a-1), 1:(r-1)]}, i.e. on heights for all peaks "before" the peak under consideration (see argument \code{by.allele} for details).}
}
If all contributors are known, the three distributions are the same
due to independence of the peak heights.
}
\examples{
data(MC15, MC18, USCaucasian)
mix <- DNAmixture(list(MC15, MC18), C = list(50,50), k = 3, K = c("K1", "K3", "K2"),
database = USCaucasian)
p <- mixpar(rho = list(30, 30), eta = list(30, 30), xi = list(0.08,0.08),
            phi = list(c(K2 = 0.1, K3 = 0.2, K1 = 0.7), c(K2 = 0.1, K3 = 0.2, K1 = 0.7)))
pred <- predict(mix, p)
pred$VWA
}
\author{
Therese Graversen
}
