% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapGenotypes.R
\name{summary.map.genotypes}
\alias{summary.map.genotypes}
\alias{print.summary.map.genotypes}
\title{Summary of best genotypes}
\usage{
\method{summary}{map.genotypes}(object, ...)

\method{print}{summary.map.genotypes}(x, markers = names(x), ...)
}
\arguments{
\item{object}{An object returned by \code{\link{map.genotypes}}.}

\item{...}{arguments passed on to other methods.}

\item{x}{An object of class \code{"summary.map.genotypes"}, typically returned by \code{summary.map.genotypes}.}

\item{markers}{Optionally, a subset of markers to print}
}
\value{
A \code{data.frame} with two columns per unknown
contributor under consideration and a column \code{Prob}
containing the probability of the configuration.
}
\description{
The maximum posterior configurations of genotypes as returned by
\code{\link{map.genotypes}}, but in the format of pairs of alleles
rather than raw allelecounts. When a subset of alleles are
considered, then the value \code{NA} is used to denote an allele outside
this subset; in particular, if \code{type="seen"} is used in
\code{\link{map.genotypes}}, then \code{NA} corresponds to the
allele having dropped out in all of the mixtures included in the
model.
}
\seealso{
\code{\link{map.genotypes}}
}
\author{
Therese Graversen
}
