% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DMOEM.R
\name{DMOEM}
\alias{DMOEM}
\title{The DMOEM is an overrelaxation algorithm in distributed manner, which is used to solve the parameter estimation of Poisson mixture model.}
\usage{
DMOEM(
  y,
  M,
  K,
  seed,
  alpha0,
  lambda0,
  MOEMalpha0,
  MOEMlambda0,
  omega,
  T,
  epsilon
)
}
\arguments{
\item{y}{is a data matrix}

\item{M}{is the number of subsets}

\item{K}{is the number of Poisson distribution}

\item{seed}{is the recommended way to specify seeds}

\item{alpha0}{is the initial value of the mixing weight under the EM algorithm}

\item{lambda0}{is the initial value of the mean under the EM algorithm}

\item{MOEMalpha0}{is the initial value of the mixing weight under the monotonically overrelaxed EM algorithm}

\item{MOEMlambda0}{is the initial value of the mean under the monotonically overrelaxed EM algorithm}

\item{omega}{is the overrelaxation factor}

\item{T}{is the number of iterations}

\item{epsilon}{is the threshold value}
}
\value{
DMOEMtime,DMOEMalpha,DMOEMlambda
}
\description{
The DMOEM is an overrelaxation algorithm in distributed manner, which is used to solve the parameter estimation of Poisson mixture model.
}
\examples{
library(stats)
set.seed(637351)
K=5 
alpha1=c(rep(1/K,K)) 
lambda1=c(1,2,3,4,5) 
n=300 
U=sample(c(1:n),n,replace=FALSE)
y= c(rep(0,n)) 
for(i in 1:n){
if(U[i]<=0.2*n){
y[i] = rpois(1,lambda1[1])} 
else if(U[i]>0.2*n & U[i]<=0.4*n){
y[i] = rpois(1,lambda1[2])} 
else if(U[i]>0.4*n & U[i]<=0.6*n){
y[i] = rpois(1,lambda1[3])} 
else if(U[i]>0.6*n & U[i]<=0.8*n){
y[i] = rpois(1,lambda1[4])}
else if(U[i]>0.8*n ){
y[i] = rpois(1,lambda1[5])} 
}
M=5
seed=637351
set.seed(123) 
e=sample(c(1:n),K)
alpha0= MOEMalpha0=e/sum(e)
lambda0= MOEMlambda0=c(1.5,2.5,3.5,4.5,5.5)
omega=0.8
T=10
epsilon=0.005
DMOEM(y,M,K,seed,alpha0,lambda0,MOEMalpha0,MOEMlambda0,omega,T,epsilon)
}
