% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DOSPortfolio.R
\name{DOSPortfolio}
\alias{DOSPortfolio}
\title{The Dynamic Optimal Shrinkage Portfolio interface.}
\usage{
DOSPortfolio(
  data,
  reallocation_points,
  relative_loss = NULL,
  target_portfolio = rep(1, ncol(data))/ncol(data),
  shrinkage_type = "non-overlapping"
)
}
\arguments{
\item{data}{an n by p matrix of asset returns. Columns represent different
assets rows are observations, where n>p, containing, for instance, log-returns.}

\item{reallocation_points}{a vector of reallocation points. The reallocation
points determine when the holding portfolio should be reconstructed and its
weights should be recomputed.}

\item{relative_loss}{possibly a numeric or NULL. The initial value of the
relative loss in the variance of the target portfolio. If its NULL, then it
will be initialized with the first subsample and the function
\code{\link{r0Strategy}}.}

\item{target_portfolio}{a vector which determines the weights of the target
portfolio used when the shrinkage estimator of the global minimum variance
portfolio is constructed for the first time.}

\item{shrinkage_type}{the type of shrinkage estimator to use. The two
implemented approaches are "non-overlapping" and "overlapping".}
}
\value{
An S3 class which contains the matrix of the constructed weights of
the dynamic shrinkage estimator of the global minimum variance portfolio and
the type of the shrinkage estimator (i.e., "overlapping" or
"non-overlapping") that was used in its construction. Each row of the weight
matrix corresponds to the reallocation point and the column corresponds to the
asset.
}
\description{
This is the main function to compute the weights of the global minimum
variance portfolio by using the dynamic optimal shrinkage estimators presented
in Eq. (2.11) and Eq. (2.23) of
\insertCite{BODNAR21dynshrink;textual}{DOSPortfolio}. It implements two
different estimators for the shrinkage coefficients, one using overlapping
samples (see, Eq. (2.23) of
\insertCite{BODNAR21dynshrink;textual}{DOSPortfolio}) and one using
non-overlapping samples (see, Eq. (2.11) of
\insertCite{BODNAR21dynshrink;textual}{DOSPortfolio}).
}
\examples{
n <- 250*2
p <- 80
c <- p/n
reallocation_points <- c(120, 240)
data <- sqrt(5/3) * matrix(rt(n*p, df=5) , ncol=p, nrow=n)
weights <- DOSPortfolio(data, reallocation_points, 1)
}
\references{
\insertAllCited{}
}
\seealso{
Section 2.1 and 2.2 of \insertCite{BODNAR21dynshrink}{DOSPortfolio}
}
