% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_extendedbacteria_ode.R
\name{simulate_extendedbacteria_ode}
\alias{simulate_extendedbacteria_ode}
\title{Extended Bacteria model - ODE}
\usage{
simulate_extendedbacteria_ode(
  B = 100,
  I = 1,
  A = 1,
  g = 1,
  Bmax = 1e+05,
  dB = 0.5,
  kI = 1e-04,
  kA = 1e-04,
  rI = 1,
  Imax = 1e+05,
  dI = 1,
  rA = 1,
  h = 1000,
  dA = 0.1,
  tstart = 0,
  tfinal = 100,
  dt = 0.01
)
}
\arguments{
\item{B}{: starting value for bacteria : numeric}

\item{I}{: starting value for innate immune response : numeric}

\item{A}{: starting value for adaptive immune response : numeric}

\item{g}{: maximum rate of bacteria growth : numeric}

\item{Bmax}{: bacteria carrying capacity : numeric}

\item{dB}{: bacteria death rate : numeric}

\item{kI}{: rate of bacteria killing by innate response : numeric}

\item{kA}{: rate of bacteria killing by adaptive response : numeric}

\item{rI}{: innate response growth rate : numeric}

\item{Imax}{: innate response carrying capacity : numeric}

\item{dI}{: innate response decay rate : numeric}

\item{rA}{: adaptive response growth rate : numeric}

\item{h}{: adaptive response half-growth : numeric}

\item{dA}{: adaptive response decay rate : numeric}

\item{tstart}{: start time of simulation : numeric}

\item{tfinal}{: final time of simulation : numeric}

\item{dt}{: times for which result is returned : numeric}
}
\value{
The function returns the output as a list.
The time-series from the simulation is returned as a dataframe saved as list element \code{ts}.
The \code{ts} dataframe has one column per compartment/variable. The first column is time.
}
\description{
A bacteria infection model with 3 compartments, implemented as set of ODEs.
The model tracks bacteria, and one compartment each for innate and adaptive immune response.
The processes modeled are bacteria growth, death and killing by the immune response,
and growth and decay of each immune response component.
}
\details{
The model tracks bacteria, and one compartment each for innate and adaptive immune response.
The processes modeled are bacteria growth, death and killing by the immune response,
and growth and decay of each immune response component.
The model is implemented as a set of ordinary differential equations (ODE) using the deSolve package.
This code is part of the DSAIRM R package.
For additional model details, see the corresponding app in the DSAIRM package.
}
\section{Notes}{
 The parameter dt only determines the times the solution is returned and plotted,
it is not the internal time step for the differential equation solver.
The latter is set automatically by the ODE solver.
}

\section{Warning}{
 This function does not perform any error checking.
So if you try to do something nonsensical (e.g. have negative values for parameters),
the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters:
result <- simulate_extendedbacteria_ode()
# To run the simulation with different parameter or starting values,
# supply the ones you want to change.
# all other parameters will be kept at their default values shown in the function call above
result <- simulate_extendedbacteria_ode(B = 100, g = 0.5, dI = 2)
}
