% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_1Similarity.R
\name{compute.sim}
\alias{compute.sim}
\title{Similarity}
\usage{
compute.sim(Y, X)
}
\arguments{
\item{Y}{vector of imputed values}

\item{X}{vector of true values}
}
\description{
Estimates the percentage of similarity of two univariate signals Y (imputed values) and X (true values).
}
\details{
This function returns the value of similarity of two vectors corresponding to univariate signals.
A higher similarity (\eqn{Similarity \in [0, 1]}) highlights a more accurate method for completing missing values in univariate datasets.
Both vectors Y and X must be of equal length, on the contrary an error will be displayed.
In both input vectors, eventual NA will be excluded with a warning diplayed.
}
\examples{
data(dataDTWBI)
X <- dataDTWBI[, 1] ; Y <- dataDTWBI[, 2]
compute.sim(Y,X)

# By definition, if true values is a constant vector
# and one or more imputed values are equal to the true values,
# similarity = 1.
X <- rep(2, 10)
Y <- X
compute.sim(Y,X)
}
\author{
Camille Dezecache, Hong T. T. Phan, Emilie Poisson-Caillault
}
