% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTWrapper2.R
\name{format.numerics}
\alias{format.numerics}
\title{This function formats numeric values with specified rounding and marking options.}
\usage{
\method{format}{numerics}(
  x,
  digits = 0,
  big.mark = "",
  big.interval = 3L,
  small.mark = "",
  small.interval = 5L,
  decimal.mark = getOption("OutDec"),
  input.d.mark = decimal.mark,
  preserve.width = c("common", "individual", "none"),
  zero.print = NULL,
  replace.zero = FALSE,
  drop0trailing = FALSE,
  is.cmplx = NA,
  ...
)
}
\arguments{
\item{x}{A numeric, integer, or logical vector to be formatted.}

\item{digits}{The number of digits to round to. Defaults to 0.}

\item{big.mark}{A character string used as a mark for thousands. Defaults to "".}

\item{big.interval}{An integer specifying the interval for the big mark. Defaults to 3.}

\item{small.mark}{A character string used as a mark for small intervals. Defaults to "".}

\item{small.interval}{An integer specifying the interval for the small mark. Defaults to 5.}

\item{decimal.mark}{A character string used as a decimal mark. Defaults to the value of getOption("OutDec").}

\item{input.d.mark}{The decimal mark to be used for input. Defaults to the value of \code{decimal.mark}.}

\item{preserve.width}{A character string specifying how to preserve the width of the output. Can be "common", "individual", or "none". Defaults to "common".}

\item{zero.print}{A character string to be used for printing zero. Defaults to NULL.}

\item{replace.zero}{A logical value indicating whether to replace zeros with the \code{zero.print} value. Defaults to FALSE.}

\item{drop0trailing}{A logical value indicating whether to drop trailing zeros. Defaults to FALSE.}

\item{is.cmplx}{A logical value indicating whether the input is complex. Defaults to NA.}

\item{...}{Additional arguments passed to prettyNum.}
}
\value{
A character vector with formatted numeric values.
}
\description{
This function formats numeric values with specified rounding and marking options.
}
