/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.driver.CancelState;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class CancelLock {
    private CancelState state = null;
    private OracleStatement statement = null;

    CancelLock(OracleStatement oracleStatement) {
        this.statement = oracleStatement;
        this.state = new CancelState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isIdle() {
        CancelState cancelState = this.state;
        synchronized (cancelState) {
            return this.state.isIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCanceled() {
        CancelState cancelState = this.state;
        synchronized (cancelState) {
            return this.state.isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enterExecuting() {
        CancelState cancelState = this.state;
        synchronized (cancelState) {
            assert (this.state.isIdle());
            this.state.setExecuting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exitExecuting() {
        while (true) {
            CancelState cancelState = this.state;
            synchronized (cancelState) {
                if (this.state.isExecuting()) {
                    this.state.setIdle();
                    break;
                }
                if (this.state.isCanceling()) {
                    try {
                        this.state.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (this.state.isCanceled()) {
                    if (this.statement != null && this.statement.connection.cancelInProgressFlag) {
                    }
                    this.state.setIdle();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enterCanceling() {
        CancelState cancelState = this.state;
        synchronized (cancelState) {
            if (this.state.isExecuting()) {
                this.state.setCanceling();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exitCanceling() {
        CancelState cancelState = this.state;
        synchronized (cancelState) {
            assert (this.state.isCanceling());
            this.state.setCanceled();
            this.state.notify();
        }
    }
}

