% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSUserDataObjectBase.R
\name{DSUserObjectBase}
\alias{DSUserObjectBase}
\title{DSUserObjectBase}
\value{
DSUserObjectBase object
}
\description{
DSUserObjectBase is the base object for all five user object types.
It defines the properties common to all the types
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{Id}}{The object identifier. The format is specific to each object type. See the individual
object file for the particular specification}

\item{\code{Mnemonic}}{For all object types bar indices, this is the same as the Id property.
For indices, the ID (of the form X#:Xnnnnn where n is a digit) is  returned when you create an index
and is used to manage the index via the API interface. The Mnemonic property is specified when creating an
index and is used to reference the index when using Datastream tools such as Charting, Datastream For Office, etc.
A mnemonic has format X#aaaaa where aaaaa is 1 to 6 alphanumeric characters.}

\item{\code{DisplayName}}{A string describing the object. The maximum length varies from object type to
object type.\cr
Expression: Max 30 alphanumeric characters.\cr
Index: Max 60 alphanumeric characters.\cr
List: Max 60 alphanumeric characters.\cr
Regression: Max 50 alphanumeric characters.\cr
Timeseries: Max 64 alphanumeric characters.\cr}

\item{\code{Description}}{Currently this isn't supported. When the API returns an object, the Description
property will be the same as the DisplayName property.}

\item{\code{Created}}{a datetime value representing the date when the object was first created.}

\item{\code{LastModified}}{a datetime value representing the date when the object was last updated.}

\item{\code{Owner}}{The parent Datastream ID that owns the object. This will be the parent of your Datastream ID.
For global expressions this will always be 'Admin'}

\item{\code{ShareType}}{For all objects except global expressions, this will be DSUserObjectShareTypes.
PrivateUserGroup. For global expressions it will be DSUserObjectShareTypes.Global.}

\item{\code{AccessRight}}{For all objects except global expressions, this will be DSUserObjectAccessRights.
ReadWrite. For global expressions it will be DSUserObjectAccessRights.Read.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DSUserObjectBase-new}{\code{DSUserObjectBase$new()}}
\item \href{#method-DSUserObjectBase-SetSafeUpdateParams}{\code{DSUserObjectBase$SetSafeUpdateParams()}}
\item \href{#method-DSUserObjectBase-clone}{\code{DSUserObjectBase$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSUserObjectBase-new"></a>}}
\if{latex}{\out{\hypertarget{method-DSUserObjectBase-new}{}}}
\subsection{Method \code{new()}}{
Initialize
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSUserObjectBase$new(jsonResp = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jsonResp}}{: json Response}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
DSUserObjectBase object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSUserObjectBase-SetSafeUpdateParams"></a>}}
\if{latex}{\out{\hypertarget{method-DSUserObjectBase-SetSafeUpdateParams}{}}}
\subsection{Method \code{SetSafeUpdateParams()}}{
The following parameters are set only in response when we query for user created items.
This method is called before Create or Update to ensure safe values set prior to JSON encoding
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSUserObjectBase$SetSafeUpdateParams()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSUserObjectBase-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DSUserObjectBase-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSUserObjectBase$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
