% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatastreamUserCreated_TimeSeries.R
\name{TimeSeriesClient}
\alias{TimeSeriesClient}
\title{TimeSeriesClient}
\value{
TimeSeriesClient object
}
\description{
This is the client class that manages the connection to the API server on your behalf.
It allows you to query for all your timeseries and to create/modify new timeseries.
}
\details{
Methods Supported \cr
GetAllItems : Allows you to query for all the current timeseries available for your use.\cr
GetItem : Allows you to download the details of a specific timeseries item.\cr
GetTimeseriesDateRange : Allows you to determine the supported timeseries dates between supplied start and
end dates at a specified frequency.\cr
CreateItem : Allows you to create a new timeseries item with up to 130 years of daily data.\cr
UpdateItem : Allows you to update an existing timeseries.\cr
DeleteItem : Allows you to delete an existing timeseries.\cr
}
\note{
: You need a Datastream ID which is permissioned to access the Datastream APIs. In addition, this ID also needs
to be permissioned to access the custom user object service. Attempting to access this service without these permissions
will result in a permission denied error response.

: For Daily and Weekly frequencies, if the supplied startDate falls on a weekend or a trading holiday, the returned
starting date will be the first trading day before the given start date. If the supplied endDate falls on a weekend or a
trading holiday, the returned final date will be the last trading day before the given end date. For Weekly frequencies,
this will be the last date which matches the day of the week for the first returned start date.\cr
\cr
For Monthly, Quarterly and Yearly frequencies, the returned dates are always the 1st day of each month, quarter or year.
The returned start and end dates are always the 1st days of the requested  month, quarter or year that the given start
and end dates fall within.

: For Daily and Weekly frequencies, if the supplied startDate falls on a weekend or a trading holiday, the returned
starting date will be the first trading day before the given start date. If the supplied endDate falls on a weekend or a
trading holiday, the returned final date will be the last trading day before the given end date. For Weekly frequencies,
this will be the last date which matches the day of the week for the first returned start date.\cr
\cr
For Monthly, Quarterly and Yearly frequencies, the returned dates are always the 1st day of each month, quarter or year.
The returned start and end dates are always the 1st days of the requested  month, quarter or year that the given start
and end dates fall within.
}
\examples{
{
 # first logon with your credentials.
 # Creating a TimeSeriesClient instance with your credentials
 # automatically logs on for you.

 timeseriesClient = TimeSeriesClient$new(NULL, 'YourID', 'YourPwd')

 # query for all your current timeseries items

 itemsResp = timeseriesClient$GetAllItems()
 if (!is.null(itemsResp))
 {
   if (itemsResp$ResponseStatus != DSUserObjectResponseStatus$UserObjectSuccess)
   {
     # Your Datastream Id might not be permissioned for managing
     # user created items on this API

     print(paste('GetAllItems failed with error ',
     names(DSUserObjectResponseStatus)[[itemsResp$ResponseStatus + 1]],
     ': ', itemsResp$ErrorMessage))

   }
   else if (!is.null(itemsResp$UserObjects) & itemsResp$UserObjectsCount > 0)
   {
     # You do have access to some timeseries
     # Here we just put the timeseries details into a dataframe and list them
     print(paste('GetAllItems returned', itemsResp$UserObjectsCount, 'timeseries items.'))
     df = data.frame()

     for (tsItem in itemsResp$UserObjects)
     {
      if (!is.null(tsItem))
      {
       rowdata = list(Id = tsItem$Id,
       LastModified = tsItem$LastModified,
       StartDate = ifelse(!is.null(tsItem$DateInfo),as.character(tsItem$DateInfo$StartDate),""),
       EndDate =ifelse(!is.null(tsItem$DateInfo),as.character(tsItem$DateInfo$EndDate), ""),
       Frequency = ifelse(!is.null(tsItem$DateInfo), tsItem$DateInfo$Frequency, 0),
       NoOfValues = ifelse(!is.null(tsItem$DateRange), tsItem$DateRange$ValuesCount , 0),
       Desc = tsItem$Description)
       df = rbind(df, rowdata)
      }
     }
     print(df)
  }
 }
 #Example to show how to GetItem
 # query for a specific timeseries

 tsName = 'TSZZZ001'
 tsResponse = timeseriesClient$GetItem(tsName)

 # You may want to put the timeseries request response handling into a common function.
 if (!is.null(tsResponse))
 {
   # Any request dealing with a single user created item returns a DSUserObjectResponse.
   # This has ResponseStatus property that indicates success or failure

   if (tsResponse$ResponseStatus != DSUserObjectResponseStatus$UserObjectSuccess)
   {
     print(paste('Request failed for timeseries', tsName, 'with error',
                   names(DSUserObjectResponseStatus)[[tsResponse$ResponseStatus+1]],
                   ':', tsResponse$ErrorMessage))
   }
   else if (!is.null(tsResponse$UserObject))
   {
     # The timeseries item won't be returned if you set SkipItem true
     # in CreateItem or UpdateItem

     # Here we simply display the timeseries data using a dataframe.

     tsItem = tsResponse$UserObject
     metadata = c (Id = tsItem$Id,
     Desc = tsItem$Description,
     LastModified = as.character(tsItem$LastModified),
     StartDate = ifelse (!is.null(tsItem$DateInfo), as.character(tsItem$DateInfo$StartDate), NULL),
     EndDate = ifelse(!is.null(tsItem$DateInfo),as.character(tsItem$DateInfo$EndDate), NULL),
     Frequency = ifelse(!is.null(tsItem$DateInfo),
     names(DSUserObjectFrequency)[[tsItem$DateInfo$Frequency + 1]], NULL),
     NoOfValues = ifelse(!is.null(tsItem$DateRange), tsItem$DateRange$ValuesCount , 0))

     df = data.frame(metadata)
     print(df)
     if (!is.null(tsItem$DateRange))
     {
       df = data.frame(Dates = sapply(tsItem$DateRange$Dates,
       FUN = function(x){ return (as.character(x)) }),
                         Values = sapply(tsItem$DateRange$Values,
                         FUN = function(x){ ifelse (is.null(x),
                         return (NA_character_ ), return (x) )} ))

       # Values if NULL, is printed as <NA> because, while
       # convertind list to vector either by using as.vector or sapply,
       # the NULL values in the list are deleted. and thus there will
       # be mismatch in no of rows and cannot be put in a dataframe

       print(df)

     }
   }
 }
}

}
\section{Super class}{
\code{\link[DatastreamR:DSConnect]{DatastreamR::DSConnect}} -> \code{TimeSeriesClient}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{useNaNforNotANumber}}{If Enabled, NaN is appears in output response instead of NULL}

\item{\code{TimeseriesResponseType}}{Response type}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TimeSeriesClient-new}{\code{TimeSeriesClient$new()}}
\item \href{#method-TimeSeriesClient-.checkValidTimeseriesId}{\code{TimeSeriesClient$.checkValidTimeseriesId()}}
\item \href{#method-TimeSeriesClient-.checkTimeSeriesReqValidity}{\code{TimeSeriesClient$.checkTimeSeriesReqValidity()}}
\item \href{#method-TimeSeriesClient-.checkKeyTimeseriesProperties}{\code{TimeSeriesClient$.checkKeyTimeseriesProperties()}}
\item \href{#method-TimeSeriesClient-.asGetAllResponse}{\code{TimeSeriesClient$.asGetAllResponse()}}
\item \href{#method-TimeSeriesClient-.asGetResponse}{\code{TimeSeriesClient$.asGetResponse()}}
\item \href{#method-TimeSeriesClient-.jsonRequestEncoder}{\code{TimeSeriesClient$.jsonRequestEncoder()}}
\item \href{#method-TimeSeriesClient-.jsonResponseDecoder}{\code{TimeSeriesClient$.jsonResponseDecoder()}}
\item \href{#method-TimeSeriesClient-GetAllItems}{\code{TimeSeriesClient$GetAllItems()}}
\item \href{#method-TimeSeriesClient-GetItem}{\code{TimeSeriesClient$GetItem()}}
\item \href{#method-TimeSeriesClient-CreateItem}{\code{TimeSeriesClient$CreateItem()}}
\item \href{#method-TimeSeriesClient-UpdateItem}{\code{TimeSeriesClient$UpdateItem()}}
\item \href{#method-TimeSeriesClient-DeleteItem}{\code{TimeSeriesClient$DeleteItem()}}
\item \href{#method-TimeSeriesClient-GetTimeseriesDateRange}{\code{TimeSeriesClient$GetTimeseriesDateRange()}}
\item \href{#method-TimeSeriesClient-clone}{\code{TimeSeriesClient$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="DatastreamR" data-topic="DSConnect" data-id="CheckToken"><a href='../../DatastreamR/html/DSConnect.html#method-DSConnect-CheckToken'><code>DatastreamR::DSConnect$CheckToken()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DatastreamR" data-topic="DSConnect" data-id="IsValid"><a href='../../DatastreamR/html/DSConnect.html#method-DSConnect-IsValid'><code>DatastreamR::DSConnect$IsValid()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DatastreamR" data-topic="DSConnect" data-id="getJsonResponse"><a href='../../DatastreamR/html/DSConnect.html#method-DSConnect-getJsonResponse'><code>DatastreamR::DSConnect$getJsonResponse()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DatastreamR" data-topic="DSConnect" data-id="getToken"><a href='../../DatastreamR/html/DSConnect.html#method-DSConnect-getToken'><code>DatastreamR::DSConnect$getToken()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-new"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-new}{}}}
\subsection{Method \code{new()}}{
User details can be supplied from a config file or passed directly as parameters
in the constructor of the derived user object type class.
(See the DSConnect superclass for a description of the connection parameters required)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$new(
  config = NULL,
  username = NULL,
  password = NULL,
  proxies = NULL,
  sslCer = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{Configuration File path}

\item{\code{username}}{Your Datastream Id}

\item{\code{password}}{Your Password}

\item{\code{proxies}}{Proxies if any}

\item{\code{sslCer}}{Path to CA bundle certificates file}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Timeseries Properties: \cr
useNaNforNotANumber : Non-trading days are stored as double NaNs on Datastream, JSON protocol permits NaNs as valid numbers.
Thus, all the NULLs in the converted to NaNs in the JSON requests. Responses contain the NULLs, But this should be converted
to Nans for Plotting purposes. If you want to receive NaN float values, set useNaNforNotANumber to TRUE, any NULLs in the returned
array of float values will be converted to NaNs.
}

\subsection{Returns}{
TimeSeriesClient object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-.checkValidTimeseriesId"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-.checkValidTimeseriesId}{}}}
\subsection{Method \code{.checkValidTimeseriesId()}}{
A helper method to check the timeseries Id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$.checkValidTimeseriesId(inputId)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inputId}}{: Timeseries Id}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL if Timeseries id is valid else error string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-.checkTimeSeriesReqValidity"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-.checkTimeSeriesReqValidity}{}}}
\subsection{Method \code{.checkTimeSeriesReqValidity()}}{
A helper method to check some of the mandatory fields of timeseries for its validity
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$.checkTimeSeriesReqValidity(tsItem)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tsItem}}{Timeseries Item}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL if Timeseries id is valid else error string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-.checkKeyTimeseriesProperties"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-.checkKeyTimeseriesProperties}{}}}
\subsection{Method \code{.checkKeyTimeseriesProperties()}}{
A helper method to check the Timeseries properties
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$.checkKeyTimeseriesProperties(tsItem)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tsItem}}{Timeseries Item}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL if Timeseries id is valid else error string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-.asGetAllResponse"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-.asGetAllResponse}{}}}
\subsection{Method \code{.asGetAllResponse()}}{
A helper method which converts the JSON response to GetAllResponse Object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$.asGetAllResponse(jsonDict)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jsonDict}}{JSON Response}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
DSUserObjectGetAllResponse object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-.asGetResponse"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-.asGetResponse}{}}}
\subsection{Method \code{.asGetResponse()}}{
A helper method which converts the JSON response to GetResponse Object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$.asGetResponse(jsonDict)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jsonDict}}{JSON Response}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
DSUserObjectResponse object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-.jsonRequestEncoder"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-.jsonRequestEncoder}{}}}
\subsection{Method \code{.jsonRequestEncoder()}}{
A helper method that reformats the raw request to JSON format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$.jsonRequestEncoder(request)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{Raw request}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
return JSON formatted list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-.jsonResponseDecoder"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-.jsonResponseDecoder}{}}}
\subsection{Method \code{.jsonResponseDecoder()}}{
A helper method that converts JSON Response to a given class response type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$.jsonResponseDecoder(jsonResp, responseType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jsonResp}}{JSON Response}

\item{\code{responseType}}{GetResponse or GetAllResponse type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
return DSUserObjectGetAllResponse or DSUserObjectGetResponse object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-GetAllItems"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-GetAllItems}{}}}
\subsection{Method \code{GetAllItems()}}{
This method returns all the current timeseries you can use in Datastream queries.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$GetAllItems()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
DSUserObjectGetAllResponse object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-GetItem"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-GetItem}{}}}
\subsection{Method \code{GetItem()}}{
GetItem returns the details for an individual timeseries.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$GetItem(itemId)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{itemId}}{: a valid timeseries Id.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
DSUserObjectResponse object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-CreateItem"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-CreateItem}{}}}
\subsection{Method \code{CreateItem()}}{
This method attempts to create the given DSTimeSeriesRequestObject via the API service
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$CreateItem(newItem, overWrite = FALSE, skipItemReturn = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newItem}}{A DSTimeSeriesRequestObject containing the data used for creating the Timeseries.}

\item{\code{overWrite}}{If the given Timeseries Id already exists on the system, the create call will be rejected.
Set overWrite = True to overwrite the existing item with new Timeseries.}

\item{\code{skipItemReturn}}{: Upon successful creation of an item, the server requests the new item from the mainframe
and returns it in the response object. For faster processing, set skipItemReturn = True to skip returning the
object in the response}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
DSUserObjectResponse object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-UpdateItem"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-UpdateItem}{}}}
\subsection{Method \code{UpdateItem()}}{
This method attempts to modify a timeseries item using the given DSTimeSeriesRequestObject via
the API service
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$UpdateItem(item, skipItemReturn = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{item}}{A DSTimeSeriesRequestObject containing the data used for creating the Timeseries.}

\item{\code{skipItemReturn}}{Upon successful creation of an item, the server requests the new item from the
mainframe and returns it in the response object. For faster processing, set skipItemReturn = True to
skip returning the object in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
DSUserObjectResponse object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-DeleteItem"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-DeleteItem}{}}}
\subsection{Method \code{DeleteItem()}}{
DeleteItem allows you to delete an existing timeseries
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$DeleteItem(itemId)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{itemId}}{a valid timeseries Id.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-GetTimeseriesDateRange"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-GetTimeseriesDateRange}{}}}
\subsection{Method \code{GetTimeseriesDateRange()}}{
This method allows you to determine the supported dates between supplied start and end dates
at a specified frequency.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$GetTimeseriesDateRange(
  startDate,
  endDate,
  frequency = DSUserObjectFrequency$Daily
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{startDate}}{A date specifying the beginning of the date range}

\item{\code{endDate}}{A date specifying the end of the date range}

\item{\code{frequency}}{A DSUserObjectFrequency enumeration defining if the frequency should be daily,
weekly, monthly, quarterly or yearly.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
DSTimeSeriesDateRangeResponse object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TimeSeriesClient-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TimeSeriesClient-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TimeSeriesClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
