% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry.R
\name{symmetry}
\alias{symmetry}
\title{Symmetry of components}
\usage{
symmetry(xy, names = "num")
}
\arguments{
\item{xy}{signal (vector or matrix)}

\item{names}{the names to use for the resulting vector. If NULL no names are
provided, if NA its the names of the columns of the xy matrix, if "num" it
the column index of the matrix xy}
}
\description{
The function returns the highest factor of amplitude either in
negative or positive values. This quantifies the symmetry of components.
}
\examples{
set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
  rnorm(n, sd = 0.5) + t * 0.01

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt <- cumsum(inter_dt)

dec <- extricate(xy, dt, nimf = 7, sifting = 10,
                 repl = 1, comb = 40, factor_noise = 10,
                 speak = TRUE, output_sifting = TRUE)

symmetry(dec$m)

plot_emd(dec, select = c(6,8,9), pdf = FALSE, adapt.axis = TRUE)

}
