% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kin_time_invariant_2sex.R
\name{kin_time_invariant_2sex}
\alias{kin_time_invariant_2sex}
\title{Estimate kin counts in a time invariant framework for two-sex model.}
\usage{
kin_time_invariant_2sex(
  pf = NULL,
  pm = NULL,
  ff = NULL,
  fm = NULL,
  sex_focal = "f",
  birth_female = 1/2.04,
  pif = NULL,
  pim = NULL,
  output_kin = NULL,
  list_output = FALSE
)
}
\arguments{
\item{pf}{numeric. A vector of survival probabilities for females with same length as ages.}

\item{pm}{numeric. A vector of survival probabilities for males with same length as ages.}

\item{ff}{numeric. A vector of age-specific fertility rates for females with same length as ages.}

\item{fm}{numeric. A vector of age-specific fertility rates for males with same length as ages.}

\item{sex_focal}{character. "f" for female or "m" for male.}

\item{birth_female}{numeric. Female portion at birth.}

\item{pif}{numeric. For using some specific non-stable age distribution of childbearing for mothers (same length as ages). Default \code{NULL}.}

\item{pim}{numeric. For using some specific non-stable age distribution of childbearing for fathers (same length as ages). Default \code{NULL}.}

\item{output_kin}{character. kin to return, considering matrilineal names. For example "m" for parents, "d" for children, etc. See the \code{vignette} for all kin types.}

\item{list_output}{logical. Results as a list with \code{output_kin} elements, with focal´s age in columns and kin ages in rows (2 * ages, last chunk of ages for death experience). Default \code{FALSE}}
}
\value{
A data frame with focal´s age, related ages and type of kin
(for example \code{d} is children, \code{oa} is older aunts/uncles, etc.), sex, alive and death. If \code{list_output = TRUE} then this is a list.
}
\description{
Two-sex matrix framework for kin count estimates.This produces kin counts grouped by kin, age and sex of
each relatives at each Focal´s age. For example, male cousins from aunts and uncles from different sibling's parents
are grouped in one male count of cousins.
}
\details{
See Caswell (2022) for details on formulas.
}
