% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trav_reverse_edge.R
\name{trav_reverse_edge}
\alias{trav_reverse_edge}
\title{Traverse to any reverse edges}
\usage{
trav_reverse_edge(graph, add_to_selection = FALSE)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{add_to_selection}{An option to either add the reverse edges to the
active selection of edges (\code{TRUE}) or switch the active selection entirely
to those reverse edges (\code{FALSE}, the default case).}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
From an active selection of edges in a graph object of class \code{dgr_graph},
traverse to any available reverse edges between the nodes common to the
selected edges. For instance, if an active selection has the edge \code{1->2} but
there is also an (not selected) edge \code{2->1}, then this function can either
switch to the selection of \code{2->1}, or, incorporate both those edges into the
active selection of edges.

This traversal function makes use of an active selection of edges. After the
traversal, depending on the traversal conditions, there will either be a
selection of edges or no selection at all.

Selections of edges can be performed using the following selection
(\verb{select_*()}) functions: \code{\link[=select_edges]{select_edges()}}, \code{\link[=select_last_edges_created]{select_last_edges_created()}},
\code{\link[=select_edges_by_edge_id]{select_edges_by_edge_id()}}, or \code{\link[=select_edges_by_node_id]{select_edges_by_node_id()}}.

Selections of edges can also be performed using the following traversal
(\verb{trav_*()}) functions: \code{\link[=trav_out_edge]{trav_out_edge()}}, \code{\link[=trav_in_edge]{trav_in_edge()}},
\code{\link[=trav_both_edge]{trav_both_edge()}}, or \code{\link[=trav_reverse_edge]{trav_reverse_edge()}}.
}
\examples{
# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 4,
    type = "basic",
    label = TRUE)

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 4, 2, 3, 3),
    to =   c(4, 1, 3, 2, 1))

# Create a graph with the
# ndf and edf
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Explicitly select the edges
# `1`->`4` and `2`->`3`
graph <-
  graph \%>\%
  select_edges(
    from = 1,
      to = 4) \%>\%
  select_edges(
    from = 2,
      to = 3)

# Get the inital edge selection
graph \%>\% get_selection()

# Traverse to the reverse edges
# (edges `2`: `4`->`1` and
# `4`:`3`->`2`)
graph <-
  graph \%>\%
  trav_reverse_edge()

# Get the current selection of edges
graph \%>\% get_selection()

}
