% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treat.R
\name{treat_model}
\alias{treat_model}
\title{Specify the propensity score model for a CDE treatment}
\usage{
treat_model(object, formula, engine, separate = TRUE, include_past = TRUE, ...)
}
\arguments{
\item{object}{A \code{cde_estimator} object that contains output from a
previous call to \code{\link[=set_treatment]{set_treatment()}}.}

\item{formula}{A formula specifying the design matrix of the
covariates. Passed to fitting engine or used with
\code{\link[stats:model.frame]{stats::model.frame()}} and \code{\link[stats:model.matrix]{stats::model.matrix()}} to create the
design matrix for fitting engines that do not take formulas.}

\item{engine}{String indicating the name of the fitting engine.}

\item{separate}{Logical indicating whether the fitting algorithm
should be applied separately to each history of the treatment
variables up to this point (default) or not.}

\item{include_past}{A logical value where \code{TRUE} indicates that
formulas passed to previous \code{treat_model} calls should be appended
to the formula given.}

\item{...}{Other arguments to be passed to the engine algorithms.}
}
\description{
Specifies the functional form and estimation engine for a treatment
previously specified by \code{\link[=set_treatment]{set_treatment()}}.
}
\author{
Matthew Blackwell
}
