% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/di_iterate_sql.R
\name{surround_quote_if_needed}
\alias{surround_quote_if_needed}
\title{Helper function: Surround character values with double quotes if not present.}
\usage{
surround_quote_if_needed(value)
}
\arguments{
\item{value}{A character vector.}
}
\value{
A character vector with double quotes surrounding \code{value} if the first and last characters of \code{value} aren't yet double quotes.  For \code{value} that is already surrounded by double quotes, nothing is changed.
}
\description{
Function used internally by \link[DisImpact]{di_calc_sql} and \link[DisImpact]{di_iterate_sql} to surround variable names by double quotes in SQL queries in order to support non-alphanumeric characters in variable names.
}
