% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma.R
\name{Gamma}
\alias{Gamma}
\alias{expValGamma}
\alias{varGamma}
\alias{kthMomentGamma}
\alias{expValLimGamma}
\alias{expValTruncGamma}
\alias{stopLossGamma}
\alias{meanExcessGamma}
\alias{VatRGamma}
\alias{TVatRGamma}
\alias{mgfGamma}
\title{Gamma Distribution}
\usage{
expValGamma(shape, rate = 1/scale, scale = 1/rate)

varGamma(shape, rate = 1/scale, scale = 1/rate)

kthMomentGamma(k, shape, rate = 1/scale, scale = 1/rate)

expValLimGamma(d, shape, rate = 1/scale, scale = 1/rate)

expValTruncGamma(d, shape, rate = 1/scale, scale = 1/rate, less.than.d = TRUE)

stopLossGamma(d, shape, rate = 1/scale, scale = 1/rate)

meanExcessGamma(d, shape, rate = 1/scale, scale = 1/rate)

VatRGamma(kap, shape, rate = 1/scale, scale = 1/rate)

TVatRGamma(kap, shape, rate = 1/scale, scale = 1/rate)

mgfGamma(t, shape, rate = 1/scale, scale = 1/rate)
}
\arguments{
\item{shape}{shape parameter \eqn{\alpha}{alpha}, must be positive.}

\item{rate}{rate parameter \eqn{\beta}{beta}, must be positive.}

\item{scale}{alternative parameterization to the rate parameter, scale = 1 / rate.}

\item{k}{kth-moment.}

\item{d}{cut-off value.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}

\item{kap}{probability.}

\item{t}{t.}
}
\value{
Function :
  \itemize{
    \item \code{\link{expValGamma}}  gives the expected value.
    \item \code{\link{varGamma}}  gives the variance.
    \item \code{\link{kthMomentGamma}}  gives the kth moment.
    \item \code{\link{expValLimGamma}}  gives the limited mean.
    \item \code{\link{expValTruncGamma}}  gives the truncated mean.
    \item \code{\link{stopLossGamma}}  gives the stop-loss.
    \item \code{\link{meanExcessGamma}}  gives the mean excess loss.
    \item \code{\link{VatRGamma}}  gives the Value-at-Risk.
    \item \code{\link{TVatRGamma}}  gives the Tail Value-at-Risk.
    \item \code{\link{mgfGamma}}  gives the moment generating function (MGF).
  }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Gamma distribution with shape parameter \eqn{\alpha}{alpha} and rate
parameter \eqn{\beta}{beta}.
}
\details{
The Gamma distribution with shape parameter \eqn{\alpha}{a} and rate
parameter \eqn{\beta}{b} has density:
  \deqn{f\left(x\right) = \frac{\beta^{\alpha}}{\Gamma(\alpha)} x^{\alpha - 1}%
  \textrm{e}^{-\beta x}}{f(x) = b^a / \Gamma(a) x^{a - 1} e^{-b x}}
for \eqn{x \in \mathcal{R}^+}{x > 0}, \eqn{\beta, \alpha > 0}{b, a > 0}.
}
\note{
Function VatRGamma is a wrapper for the \code{\link[stats]{qgamma}}
function stats package.
}
\examples{

# With scale parameter
expValGamma(shape = 3, scale = 4)

# With rate parameter
expValGamma(shape = 3, rate = 0.25)


# With scale parameter
varGamma(shape = 3, scale = 4)

# With rate parameter
varGamma(shape = 3, rate = 0.25)


# With scale parameter
kthMomentGamma(k = 2, shape = 3, scale = 4)

# With rate parameter
kthMomentGamma(k = 2, shape = 3, rate = 0.25)


# With scale parameter
expValLimGamma(d = 2, shape = 3, scale = 4)

# With rate parameter
expValLimGamma(d = 2, shape = 3, rate = 0.25)


# With scale parameter
expValTruncGamma(d = 2, shape = 3, scale = 4)

# With rate parameter
expValTruncGamma(d = 2, shape = 3, rate = 0.25)

# values greather than d
expValTruncGamma(d = 2, shape = 3, rate = 0.25, less.than.d = FALSE)


# With scale parameter
stopLossGamma(d = 2, shape = 3, scale = 4)

# With rate parameter
stopLossGamma(d = 2, shape = 3, rate = 0.25)


# With scale parameter
meanExcessGamma(d = 2, shape = 3, scale = 4)

# With rate parameter
meanExcessGamma(d = 2, shape = 3, rate = 0.25)


# With scale parameter
VatRGamma(kap = .2, shape = 3, scale = 4)

# With rate parameter
VatRGamma(kap = .2, shape = 3, rate = 0.25)


# With scale parameter
TVatRGamma(kap = .2, shape = 3, scale = 4)

# With rate parameter
TVatRGamma(kap = .2, shape = 3, rate = 0.25)


mgfGamma(t = 1, shape = 3, rate = 5)

}
