% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NormalVaRPlot3D.R
\name{NormalVaRPlot3D}
\alias{NormalVaRPlot3D}
\title{Plots normal VaR in 3D against confidence level and holding period}
\usage{
NormalVaRPlot3D(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 3
 or 4. In case there 3 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 cl VaR confidence level and must be a vector

 hp VaR holding period and must be a vector}
}
\description{
Plots the VaR of a portfolio against confidence level and holding period assuming that P/L are normally distributed, for specified confidence level and
 holding period.
}
\examples{
# Plots VaR against confidene level given geometric return data
   data <- rnorm(5, .07, .03)
   NormalVaRPlot3D(returns = data, cl = seq(.9,.99,.01), hp = 1:100)

   # Computes VaR against confidence level given mean and standard deviation of return data
   NormalVaRPlot3D(mu = .012, sigma = .03, cl = seq(.9,.99,.01), hp = 1:100)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

