% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meth_t.R
\name{t,Dyadic-method}
\alias{t,Dyadic-method}
\title{Transpose of a \code{Dyadic} object}
\usage{
\S4method{t}{Dyadic}(x)
}
\arguments{
\item{x}{\code{Dyadic}-object;}
}
\value{
The \code{Dyadic}-object that is the result of the operation with properly defined fields.
}
\description{
The \code{Dyadic} object transpose of a \code{Dyadic} object: \code{t(Dyadic)}.
}
\details{
The operations are performed in a way that is consistent with the dyadic structure of the matrices.
}
\section{References}{

Kos, M., Podgórski, K., & Wu, H. (2025). Dyadic Factorization and Efficient Inversion of Sparse Positive Definite Matrices. arXiv. https://arxiv.org/abs/2505.08144
}

\examples{
#--------------------------------------------#
#-------Transpose of a dyadic object --------#
#--------------------------------------------#

N <- 4
k <- 3

# Construct four types of dyadic matrices with made of 1's
V <- construct(N, k, type = "vert") # vertical
H <- construct(N, k, type = "horiz") # horizontal
S <- construct(N, k, type = "symm", distr = "unif") # symmetric

t(V)@type # The transpose of a vertical dyadic matrix is horizontal
t(H)@type # The transpose of a horizontal dyadic matrix is vertical

all(as.matrix(t(V)) == t(as.matrix(V))) # Should be TRUE
all(as.matrix(S) == as.matrix(t(S))) # Should be TRUE
}
\seealso{
\code{\link{Dyadic-class}} for the definition of the \code{Dyadic}-class;
\code{\link{dyadFac}} for the dyadic decomposition of dyadic matrices;
}
