% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECLRMC.R
\name{NRMS}
\alias{NRMS}
\title{Normalized Root Mean Square (NRMS) value of two matrices for evaluating their similarity (lower is better)}
\usage{
NRMS(imputed, original)
}
\arguments{
\item{imputed}{An m by n matrix}

\item{original}{An m by n matrix}
}
\value{
Returns the NRMS value of the given matrices
}
\description{
Normalized Root Mean Square (NRMS) value of two matrices for evaluating their similarity (lower is better)
}
\examples{
x = matrix(c(5.1, 4.9, NA, 4.6, 3.5, 3.0, 3.2, 3.1, 1.4, NA, 1.3, 1.5), byrow = TRUE, ncol=4)
a = ECLRMC(x, beta = 0.2)
b = LRMC(x)
NRMS(a,b)
}
