% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothness.R
\name{smoothness}
\alias{smoothness}
\alias{smoothness.default}
\alias{smoothness.formula}
\title{Measures of smoothness}
\usage{
smoothness(...)

\method{smoothness}{default}(x, y, measures = "all",
  summary = c("mean", "sd"), ...)

\method{smoothness}{formula}(formula, data, measures = "all",
  summary = c("mean", "sd"), ...)
}
\arguments{
\item{...}{Not used.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A response vector with one value for each row/component of x.}

\item{measures}{A list of measures names or \code{"all"} to include all them.}

\item{summary}{A list of summarization functions or empty for all values. See
\link{summarization} method to more information. (Default: 
\code{c("mean", "sd")})}

\item{formula}{A formula to define the output column.}

\item{data}{A data.frame dataset contained the input and output attributes.}
}
\value{
A list named by the requested smoothness measure.
}
\description{
Regression task. In regression problems, the smoother the function to be 
fitted to the data, the simpler it shall be. Larger variations in the inputs
and/or outputs, on the other hand, usually indicate the existence of more 
intricate relationships between them.
}
\details{
The following measures are allowed for this method:
 \describe{
   \item{"S1"}{Output distribution (S1) monitors whether the examples 
     joined in the MST have similar output values. Lower values indicate 
     simpler problems, where the outputs of similar examples in the input 
     space are also next to each other.}
   \item{"S2"}{Input distribution (S2) measure how similar in the input space
     are data items with similar outputs based on distance.}
   \item{"S3"}{Error of a nearest neighbor regressor (S3) calculates the mean
     squared error of a 1-nearest neighbor regressor  using leave-one-out.}
   \item{"S4"}{Non-linearity of nearest neighbor regressor (S4) calculates 
     the mean squared error of a 1-nearest neighbor regressor to the new 
     randomly interpolated points.}
 }
}
\examples{
## Extract all smoothness measures for regression task
data(cars)
smoothness(speed ~ ., cars)
}
\references{
Ana C Lorena and Aron I Maciel and Pericles B C Miranda and Ivan G Costa and
   Ricardo B C Prudencio. (2018). Data complexity meta-features for 
   regression problems. Machine Learning, 107, 1, 209--246.
}
\seealso{
Other complexity-measures: \code{\link{balance}},
  \code{\link{correlation}}, \code{\link{dimensionality}},
  \code{\link{linearity}}, \code{\link{neighborhood}},
  \code{\link{network}}, \code{\link{overlapping}}
}
\concept{complexity-measures}
