#' the Scaler for the pre-trained Deep Neural Network (DNN)
#'
#' @description
#' This dataset contains the means and standard deviations of the 10,000,000 datasets for
#' training the Deep Neural Network (DNN), which can be used to determine the number of factors.
#'
#' @format A \code{list} containing two \code{vector}s, each of length 54:
#' \describe{
#'   \item{means}{A numeric vector representing the means of the 54
#'                features extracted from the 10,000,000 datasets.}
#'   \item{sds}{A numeric vector representing the standard deviations of
#'              the 54 features extracted from the 10,000,000 datasets.}
#' }
#' @seealso \code{\link[EFAfactors]{NN}}, \code{\link[EFAfactors]{load.scaler}},
#' \code{\link[EFAfactors]{data.datasets.DNN}}, \code{\link[EFAfactors]{normalizor}}
#'
#'
#' @examples
#' data(data.scaler.DNN)
#' print(data.scaler.DNN)
#'
#' data.scaler <- load.scaler(model="DNN")
#' print(data.scaler)
#'
#' @docType data
#' @name data.scaler.DNN
NULL
