% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN.R
\name{EQRN_excess_probability}
\alias{EQRN_excess_probability}
\title{Tail excess probability prediction using an EQRN_iid object}
\usage{
EQRN_excess_probability(
  val,
  fit_eqrn,
  X,
  intermediate_quantiles,
  interm_lvl = fit_eqrn$interm_lvl,
  body_proba = "default",
  proba_type = c("excess", "cdf"),
  device = default_device()
)
}
\arguments{
\item{val}{Quantile value(s) used to estimate the conditional excess probability or cdf.}

\item{fit_eqrn}{Fitted \code{"EQRN_iid"} object.}

\item{X}{Matrix of covariates to predict the corresponding response's conditional excess probabilities.}

\item{intermediate_quantiles}{Vector of intermediate conditional quantiles at level \code{fit_eqrn$interm_lvl}.}

\item{interm_lvl}{Optional, checks that \code{interm_lvl == fit_eqrn$interm_lvl}.}

\item{body_proba}{Value to use when the predicted conditional probability is below \code{interm_lvl}
(in which case it cannot be precisely assessed by the model).
If \code{"default"} is given (the default), \code{paste0(">",1-interm_lvl)} is used if \code{proba_type=="excess"},
and \code{paste0("<",interm_lvl)} is used if \code{proba_type=="cdf"}.}

\item{proba_type}{Whether to return the \code{"excess"} probability over \code{val} (default) or the \code{"cdf"} at \code{val}.}

\item{device}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
}
\value{
Vector of probabilities (and possibly a few \code{body_proba} values if \code{val} is not large enough) of length \code{nrow(X)}.
}
\description{
Tail excess probability prediction using an EQRN_iid object
}
