% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN.R
\name{compute_EQRN_GPDLoss}
\alias{compute_EQRN_GPDLoss}
\title{Generalized Pareto likelihood loss of a EQRN_iid predictor}
\usage{
compute_EQRN_GPDLoss(
  fit_eqrn,
  X,
  y,
  intermediate_quantiles = NULL,
  interm_lvl = fit_eqrn$interm_lvl,
  device = default_device()
)
}
\arguments{
\item{fit_eqrn}{Fitted \code{"EQRN_iid"} object.}

\item{X}{Matrix of covariates.}

\item{y}{Response variable vector.}

\item{intermediate_quantiles}{Vector of intermediate conditional quantiles at level \code{fit_eqrn$interm_lvl}.}

\item{interm_lvl}{Optional, checks that \code{interm_lvl == fit_eqrn$interm_lvl}.}

\item{device}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
}
\value{
Negative GPD log likelihood of the conditional EQRN predicted parameters
over the response exceedances over the intermediate quantiles.
}
\description{
Generalized Pareto likelihood loss of a EQRN_iid predictor
}
