% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy_metrics.R
\name{multilevel_q_pred_error}
\alias{multilevel_q_pred_error}
\title{Multilevel 'quantile_prediction_error'}
\usage{
multilevel_q_pred_error(
  y,
  Pred_Q,
  proba_levels,
  prefix = "",
  na.rm = FALSE,
  give_names = TRUE
)
}
\arguments{
\item{y}{Vector of observations.}

\item{Pred_Q}{Matrix of of size \code{length(y)} times \code{proba_levels},
whose columns are the quantile predictions at each \code{proba_levels} and
each row corresponds to an observation or realisation.}

\item{proba_levels}{Vector of probability levels at which the predictions were made.
Must be of length \code{ncol(Pred_Q)}.}

\item{prefix}{A string prefix to add to the output's names (if \code{give_names} is \code{TRUE}).}

\item{na.rm}{A logical value indicating whether \code{NA} values should be stripped before the computation proceeds.}

\item{give_names}{Whether to name the output errors (bool).}
}
\value{
A vector of length \code{length(proba_levels)} giving the quantile prediction error calibration metrics
between each column of \code{Pred_Q} and the observations.
If \code{give_names} is \code{TRUE}, the output vector is named \code{paste0(prefix, "qPredErr_q", proba_levels)}.
}
\description{
Multilevel version of \code{\link[=quantile_prediction_error]{quantile_prediction_error()}}.
}
