\name{EQUAL_decrypt_file}
\alias{EQUAL_decrypt_file}
\title{
Decrypt a file
}
\description{
"Decrypts a file using the private key generated by
\code{\link[=EQUAL_encrypt_generate_keys]{EQUAL_encrypt_generate_keys()}}
function and \pkg{openssl}. This reverses the process followed in
\code{\link[=EQUAL_encrypt_file]{EQUAL_encrypt_file()}} function."
}
\usage{
EQUAL_decrypt_file(encrypted_data, private_key_folder, key_name,
data_storage_folder)
}
\arguments{
\item{encrypted_data}{Encrypted data that must be decrypted}
\item{private_key_folder}{Location of the private key}
\item{key_name}{Name of the private key}
\item{data_storage_folder}{Location to store the decrypted file temporarily}
}
\value{
0 (the decrypted file is saved in the temporary directory)
}
\references{
\url{https://sites.google.com/view/equal-group/home}
}
\author{
Kurinchi Gurusamy
}
\note{
"This is part of a suite of functions required to allow encrypting and
decrypting whole files and encrypting and decrypting columns of data
programs to run. This is unlikely to be used as a stand alone function."
}
\seealso{
\code{\link[=EQUAL_encrypt_generate_keys]{EQUAL_encrypt_generate_keys()}}
\code{\link[openssl:aes_cbc_decrypt]{openssl::aes_cbc_decrypt()}}
\code{\link[openssl:rsa_decrypt]{openssl::rsa_decrypt()}}
}
\concept{EQUALencrypt}
\examples{
library(openssl)
# Encryption keys ####
test_folder <- tempfile(pattern = "folder_")
public_key_folder <- paste0(test_folder, "/public_key_folder")
private_key_folder <- paste0(test_folder, "/private_key_folder")
dir.create(test_folder)
dir.create(public_key_folder)
dir.create(private_key_folder)
encryption_keys <- EQUAL_encrypt_generate_keys(
  public_key_folder = public_key_folder,
  private_key_folder = private_key_folder,
  key_name = "encryption_key.txt")
# Data ####
data <- lapply(1:3, function(x) {
  mean = sample(1:100, 1, replace = FALSE)
  sd = sample(1:100, 1, replace = FALSE)
  rnorm(100, mean = mean, sd = sd)
})
data <- do.call(cbind.data.frame, data)
colnames(data) <- paste0("v", formatC(1:3, width = 6, flag = "0"))
test_file <- write.csv(data, paste0(tempdir(), "/test.csv"),
row.names = FALSE, na = "")
# Encrypt data ####
encrypted_data <- EQUAL_encrypt_file(file_name = paste0(tempdir(), "/test.csv"),
public_key_folder = public_key_folder, key_name = "encryption_key.txt")
data_storage_folder <- paste0(test_folder, "/data_storage_folder")
dir.create(data_storage_folder)
# Results ####
results <- EQUAL_decrypt_file(encrypted_data = encrypted_data,
                              private_key_folder = private_key_folder,
                              key = "encryption_key.txt",
                              data_storage_folder = data_storage_folder)

}
