% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_phase2.R
\name{run_phase2_multiple}
\alias{run_phase2_multiple}
\title{Phase 2 wrapper for multiple observation}
\usage{
run_phase2_multiple(
  partitions,
  estimates.phase1,
  inv.zcov,
  inv.scaling,
  z.obs,
  presence.tables,
  nodes,
  effects,
  objects,
  burnin,
  thining,
  num.steps,
  gainfactors,
  r.truncation.p2,
  min.iter,
  max.iter,
  multiplication.iter,
  neighborhood,
  fixed.estimates,
  numgroups.allowed,
  numgroups.simulated,
  sizes.allowed,
  sizes.simulated,
  double.averaging,
  parallel = FALSE,
  cpus = 1,
  verbose = FALSE
)
}
\arguments{
\item{partitions}{observed partitions}

\item{estimates.phase1}{vector containing parameter values after phase 1}

\item{inv.zcov}{inverted covariance matrix}

\item{inv.scaling}{scaling matrix}

\item{z.obs}{observed statistics}

\item{presence.tables}{data frame to indicate which times nodes are present in the partition}

\item{nodes}{node set (data frame)}

\item{effects}{effects/sufficient statistics (list with a vector "names", and a vector "objects")}

\item{objects}{objects used for statistics calculation (list with a vector "name", and a vector "object")}

\item{burnin}{integer for the number of burn-in steps before sampling}

\item{thining}{integer for the number of thining steps between sampling}

\item{num.steps}{number of sub-phases in phase 2}

\item{gainfactors}{vector of gain factors}

\item{r.truncation.p2}{truncation factor}

\item{min.iter}{minimum numbers of steps in each subphase}

\item{max.iter}{maximum numbers of steps in each subphase}

\item{multiplication.iter}{used to calculate min.iter and max.iter if not specified}

\item{neighborhood}{vector for the probability of choosing a particular transition in the chain}

\item{fixed.estimates}{if some parameters are fixed, list with as many elements as effects, these elements equal a fixed value if needed, or NULL if they should be estimated}

\item{numgroups.allowed}{vector containing the number of groups allowed in the partition (now, it only works with vectors like num_min:num_max)}

\item{numgroups.simulated}{vector containing the number of groups simulated}

\item{sizes.allowed}{vector of group sizes allowed in sampling (now, it only works for vectors like size_min:size_max)}

\item{sizes.simulated}{vector of group sizes allowed in the Markov chain but not necessraily sampled (now, it only works for vectors like size_min:size_max)}

\item{double.averaging}{boolean to indicate whether we follow the double-averaging procedure (often leads to better convergence)}

\item{parallel}{boolean to indicate whether the code should be run in parallel}

\item{cpus}{number of cpus if parallel = TRUE}

\item{verbose}{logical: should intermediate results during the estimation be printed or not? Defaults to FALSE.}
}
\value{
a list
}
\description{
Phase 2 wrapper for multiple observation
}
