% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_eztune.R
\name{predict.eztune}
\alias{predict.eztune}
\title{Prediction function for EZtune}
\usage{
\method{predict}{eztune}(object, newdata, ...)
}
\arguments{
\item{object}{An object of class "\code{eztune}".}

\item{newdata}{Matrix or data frame containing the test or validation dataset.}

\item{...}{Additional parameters to pass to predict.}
}
\value{
Function returns a vector of predictions if the response is
continuous. If the response is binary, a \code{data.frame} with the predicted
response and the probabilities of each response type is returned.
}
\description{
\code{predict.eztune} Computes predictions for a validation dataset.
}
\examples{
library(EZtune)
data(lichen)
data(lichenTest)

y <- lichen[, 2]
x <- lichen[, 9:41]

# Optimize an SVM classification model using the default settings
mod1 <- eztune(x, y)

# Obtain predictions using the lichenTest dataset and compute classification
# error
pred <- predict(mod1, lichenTest)
mean(pred$predictions == as.factor(lichenTest$LobaOreg))

# Optimize an SVM regression model using the default settings
library(mlbench)
library(dplyr)
library(yardstick)
data(BostonHousing2)
bh <- mutate(BostonHousing2, lcrim = log(crim)) \%>\%
  select(-town, -medv, -crim)
x <- bh[, c(1:3, 5:17)]
y <- bh[, 4]
mod2 <- eztune(x, y)

# Obtain predictions from the original data and compute the rmse
pred <- predict(mod2, x)
rmse_vec(pred, y)
}
