% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistEco.R
\name{DistEco}
\alias{DistEco}
\title{Tools for internal data structure exploration}
\usage{
DistEco(data, distance.method = "inner_product", transpose = TRUE,
  symm = FALSE, plot = c("heatmap", "network"),
  palette = "colorblind", spinglass = TRUE, run = 10,
  spinglass.groups = c("rounded", "raw"), manual.groups = NULL,
  return.network = TRUE, ...)
}
\arguments{
\item{data}{A community or environmental matrix, containing
species or variables as columns and sites as rows.}

\item{distance.method}{The distance method to be used for the
calculation of the distance matrix. Must be one of
philentropy::distance}

\item{transpose}{Logical. If TRUE, the distance matrix is
calculated between species. If FALSE, it is calculated between
sites.}

\item{symm}{Logical indicating if x should be treated symmetrically;
can only be true when x is a square matrix. See stats::heatmap.}

\item{plot}{The kind of plot produced by the function.
Can be “heatmap” or “network”.}

\item{palette}{The colour palette for the network, if spinglass = TRUE.
Must be one of the palettes supported by qgraph.
Default to “colorblind”.}

\item{spinglass}{Logical. Whether or not to run a spinglass
algorithm to produce statistical groups for the network.
The spinglass algorithm is performed with the CommunityNetwork
function.}

\item{run}{Number of runs for the spinglass algorithm. Higher numbers
produce more trustable results but rapidly increase computation time.
Default to 10.}

\item{spinglass.groups}{If spinglass = TRUE, the type of
grouping to use from the results of the spinglass algorithm.
See Details.}

\item{manual.groups}{If spinglass = FALSE, an object that indicates
which nodes belong together. Can be a list in which each element
is a vector of integers identifying the numbers of the nodes that
belong together, or a factor.}

\item{return.network}{Logical. If TRUE, the qgraph object is returned
as output of the function.}

\item{...}{Additionnal parameters for heatmap or qgraph.}
}
\value{
A plot corresponding to the plot argument.
}
\description{
Tools for internal data structure exploration
}
\examples{
 ### Artificial data:
 SyntheticTrial <- SyntheticData(SpeciesNum = 21, CommunityNum = 3,
                                 SpCo = NULL, Length = 500,
                                 Parameters = list(a=rep(60, 3),
                                                 b=c(0,250,500),
                                                 c=rep(0.01,3)),
                                 pal = c("#008585", "#FBF2C4", "#C7522B"))

 ## Network of species, with raw spinglass groups:
 DistEco(SyntheticTrial[,2:ncol(SyntheticTrial)], transpose = TRUE,
         plot = c("network"), spinglass = TRUE, run = 10,
         spinglass.groups = c("raw"))

 ## Heatmap of species:
 DistEco(SyntheticTrial[,2:ncol(SyntheticTrial)], transpose = TRUE,
         symm = FALSE, plot = c("heatmap"))


}
