% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/andrews_lrv.R
\name{andrews_lrv}
\alias{andrews_lrv}
\title{Long-run covariance estimation using Andrews quadratic spectral kernel.}
\usage{
andrews_lrv(e)
}
\arguments{
\item{e}{a vector of residual series, for which we recommend to use the recursive residuals from larger model.}
}
\value{
a vector of Long run variance using Andrews quadratic spectral kernel HAC.
}
\description{
Given a vector of residuals, it generates the Heteroskedastic Long run variance.
}
\examples{
set.seed(2014)
x<- rnorm(15);
#Andrews kernel HAC
andrews_lrcov = andrews_lrv(x)
}
\references{
Andrews, D. W. (1991). Heteroskedasticity and autocorrelation consistent covariance matrix estimation. Econometrica: Journal of the Econometric Society, 817-858.
}
