% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envcoding.R
\name{env.sp}
\alias{env.sp}
\title{Extract the Sequence Environments}
\usage{
env.sp(data, sp, r = 10, aa = 'all', silent = TRUE)
}
\arguments{
\item{data}{input data must be a dataframe (see details).}

\item{sp}{the species of interest (it should be named as in the input dataframe).}

\item{r}{a positive integer indicating the radius of the sequence segment considered as environment.}

\item{aa}{the amino acid(s) which environments are going to be extracted.}

\item{silent}{logical. When FALSE the program progress is reported to alleviate loneliness.}
}
\value{
A list of environment sequences. Each element from the list is a vector with the environment sequences around an amino acid. So, the length list is the same as the length of aa.
}
\description{
Extracts the sequence environments around the selected amino acid(s) in the chosen species.
}
\details{
Input data must be a dataframe where each row corresponds to an individual protein. The columns contain the sequence of the protein corresponding to the row in each species. Therefore, the columns' names of this dataframe must be coherent with the names of the OTUs being analyzed.
}
\examples{
data(bovids)
env.sp(data = bovids, sp = "Bos_taurus", r = 2)
}
\seealso{
otu.vector(), otu.space()
}
