% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngram.R
\name{ngraMatrix}
\alias{ngraMatrix}
\title{Compute n-Gram Frequencies Dataframe}
\usage{
ngraMatrix(data, k = 4, silent = FALSE)
}
\arguments{
\item{data}{a dataframe with as many columns as species and one row per orthologous protein. The rows and columns must be named accordingly.}

\item{k}{a positive integer, between 1 and 5, indicating the k-mer of the words to be counted.}

\item{silent}{logical, set to FALSE to avoid loneliness.}
}
\value{
A list with two dataframes. The first one with nsp * npr columns (nsp: number of species, npr: number of proteins per species) and npe rows (npe: number of peptides, 20 for n = 1, 400 for n = 2, 8000 for n = 3 and 160000 for n = 4). The entries of the dataframe are the number of times that the indicated peptide has been counted in the given protein. Orthologous proteins are in consecutive columns, thus the first nsp columns are the orthologous of protein 1 and so on. The second dataframe contains the Species Vector Sums (each vector describes one species).
}
\description{
Computes the n-gram frequencies dataframe for the protein and species provides.
}
\details{
The argument prot can be obtained using orth() and orth.seq().
}
\examples{
ngraMatrix(bovids[,1:3], k = 2)
}
\references{
Stuart et al. Bioinformatics 2002; 18:100-108.
}
\seealso{
ngram(), svdgram()
}
