% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_Rtnow_plot.R
\name{plot.Rtnow}
\alias{plot.Rtnow}
\title{Plot the nowcasted reproduction number}
\usage{
\method{plot}{Rtnow}(x, datelab = "7d", cilevel = 0.95, xtickangle = 0, legendpos = "right",
 nowcastcol = "cornflowerblue", ...)
}
\arguments{
\item{x}{An object of class \code{Rtnow}.}

\item{datelab}{Spacing for the ticks on the x-axis.}

\item{cilevel}{Level of the credible interval.}

\item{xtickangle}{Angle of the x-ticks. Default is 0 (horizontal).}

\item{legendpos}{Position of the legend.}

\item{nowcastcol}{Color of the nowcasted \eqn{R_t} curve.}

\item{...}{Further arguments to be passed to plot.}
}
\value{
A plot of the nowcasted time-varying reproduction number.
}
\description{
This routine can be used to plot the nowcasted reproduction
number based on an object of class \code{Rtnow}.
}
\author{
Bryan Sumalinab (writing) and Oswaldo Gressani (editing).
}
